/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.jwt;

import java.util.List;
import java.util.Map;

public class JWTokenClaims {
    private final String jwtId;
    private final String issuer;
    private final String subject;
    private final List<String> audience;
    private final Long issuedAt;
    private final Long notBefore;
    private final Long expiration;
    private final Map<String, Object> additionalClaims;

    public JWTokenClaims(String jwtId, String issuer, String subject, List<String> audience, Long issuedAt, Long notBefore, Long expirationTime, Map<String, Object> additionalClaims) {
        this.jwtId = jwtId;
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience;
        this.issuedAt = issuedAt;
        this.notBefore = notBefore;
        this.expiration = expirationTime;
        this.additionalClaims = additionalClaims;
    }

    public String getJwtId() {
        return this.jwtId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public Long getIssuedAt() {
        return this.issuedAt;
    }

    public Long getNotBefore() {
        return this.notBefore;
    }

    public Long getExpiration() {
        return this.expiration;
    }

    public Map<String, Object> getAdditionalClaims() {
        return this.additionalClaims;
    }

    public Object getAdditionalClaim(String key) {
        return this.additionalClaims.get(key);
    }

    public String toString() {
        return "JWTokenClaims [jwtId=" + this.jwtId + ", issuer=" + this.issuer + ", subject=" + this.subject + ", audience=" + String.valueOf(this.audience) + ", issuedAt=" + this.issuedAt + ", notBefore=" + this.notBefore + ", expiration=" + this.expiration + ", additionalClaims=" + String.valueOf(this.additionalClaims) + "]";
    }
}

