/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.jwt;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.CurveType;
import org.clazzes.login.jbo.common.Helpers;
import org.clazzes.login.jbo.common.KeyOperation;
import org.clazzes.login.jbo.common.KeyType;
import org.clazzes.login.jbo.common.PubKeyInfo;
import org.clazzes.login.jbo.json.JsonHelper;
import org.clazzes.login.jbo.jwt.JWKPubKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKeyParser {
    private static final Logger log = LoggerFactory.getLogger(JWKeyParser.class);

    public static JWKPubKey parsePubKey(InputStream is) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(JWKPubKey.class, (JsonDeserializer)new JWKPubKeyDeserializer());
        objectMapper.registerModule((Module)module);
        return (JWKPubKey)objectMapper.readValue(is, JWKPubKey.class);
    }

    public static void formatPubKey(OutputStream os, JWKPubKey pubKey) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(JWKPubKey.class, (JsonSerializer)new JWKPubKeySerializer());
        objectMapper.registerModule((Module)module);
        objectMapper.writeValue(os, (Object)pubKey);
    }

    public static List<JWKPubKey> parsePubKeyList(InputStream is) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(JWKPubKey.class, (JsonDeserializer)new JWKPubKeyDeserializer());
        objectMapper.registerModule((Module)module);
        JWKPubKeyListHolder holder = (JWKPubKeyListHolder)objectMapper.readValue(is, JWKPubKeyListHolder.class);
        return holder.getKeys();
    }

    public static void formatPubKeyList(OutputStream os, List<JWKPubKey> pubKeyList) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(JWKPubKey.class, (JsonSerializer)new JWKPubKeySerializer());
        objectMapper.registerModule((Module)module);
        JWKPubKeyListHolder holder = new JWKPubKeyListHolder();
        holder.setKeys(pubKeyList);
        objectMapper.writeValue(os, (Object)holder);
    }

    private static class JWKPubKeyDeserializer
    extends JsonDeserializer<JWKPubKey> {
        private JWKPubKeyDeserializer() {
        }

        public Class<?> handledType() {
            return JWKPubKey.class;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JWKPubKey deserialize(JsonParser p, DeserializationContext dctxt) throws IOException, JacksonException {
            PublicKey publicKey;
            PublicKey pubKey;
            String name;
            String ctxt = "JWKPubKey";
            JsonHelper.beginObject(p, ctxt);
            String keyId = null;
            KeyType keyType = null;
            CurveType curve = null;
            Algorithm algorithm = null;
            String usage = null;
            KeyOperation[] keyOperations = null;
            String certificateUrl = null;
            Certificate[] certificateChain = null;
            byte[] certificateThumbprint = null;
            byte[] certificateThumbprintSha256 = null;
            BigInteger x = null;
            BigInteger y = null;
            BigInteger modulus = null;
            BigInteger exponent = null;
            while ((name = JsonHelper.nextName(p, ctxt)) != null) {
                if ("kid".equals(name)) {
                    keyId = JsonHelper.nextString(p, ctxt);
                    continue;
                }
                if ("kty".equals(name)) {
                    keyType = KeyType.getByJwkType(JsonHelper.nextString(p, ctxt));
                    continue;
                }
                if ("alg".equals(name)) {
                    String alg = JsonHelper.nextString(p, ctxt);
                    if ("RSA-OAEP".equals(alg)) {
                        algorithm = Algorithm.RSAES_OAEP_SHA_256;
                        continue;
                    }
                    algorithm = Algorithm.valueOf(alg);
                    continue;
                }
                if ("use".equals(name)) {
                    usage = JsonHelper.nextString(p, ctxt);
                    continue;
                }
                if ("crv".equals(name)) {
                    curve = CurveType.getByJwkType(JsonHelper.nextString(p, ctxt));
                    continue;
                }
                if ("x5u".equals(name)) {
                    certificateUrl = JsonHelper.nextString(p, ctxt);
                    continue;
                }
                if ("key_ops".equals(name)) {
                    String string;
                    ArrayList<KeyOperation> key_ops = new ArrayList<KeyOperation>();
                    JsonHelper.beginArray(p, ctxt);
                    while ((string = p.nextTextValue()) != null) {
                        key_ops.add(KeyOperation.valueOf(string));
                    }
                    JsonHelper.endArray(p, ctxt);
                    keyOperations = key_ops.toArray(new KeyOperation[key_ops.size()]);
                    continue;
                }
                if ("x5c".equals(name)) {
                    ArrayList<Certificate> certs = new ArrayList<Certificate>();
                    try {
                        String crt;
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                        JsonHelper.beginArray(p, ctxt);
                        while ((crt = p.nextTextValue()) != null) {
                            byte[] encoded = Helpers.parseBase64(crt);
                            Certificate cert = certificateFactory.generateCertificate(new ByteArrayInputStream(encoded));
                            certs.add(cert);
                        }
                        JsonHelper.endArray(p, ctxt);
                    }
                    catch (CertificateException e) {
                        throw new IllegalArgumentException("Unable to parse x5c certificate chain", e);
                    }
                    certificateChain = certs.toArray(new Certificate[certs.size()]);
                    continue;
                }
                if ("x5t".equals(name)) {
                    byte[] sha1Thumb = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                    if (sha1Thumb.length != 20) {
                        throw new IllegalArgumentException("x5t SHA1 certificate thumbprint has length [" + sha1Thumb.length + "], which is not 20.");
                    }
                    certificateThumbprint = sha1Thumb;
                    continue;
                }
                if ("x5t#S256".equals(name)) {
                    byte[] sha256Thumb = Helpers.parseBase64(JsonHelper.nextString(p, ctxt));
                    if (sha256Thumb.length != 32) {
                        throw new IllegalArgumentException("x5t#S256 SHA256 certificate thumbprint has length [" + sha256Thumb.length + "], which is not 32.");
                    }
                    certificateThumbprintSha256 = sha256Thumb;
                    continue;
                }
                if ("e".equals(name)) {
                    exponent = Helpers.parsePositiveBigInt(JsonHelper.nextString(p, ctxt));
                    continue;
                }
                if ("n".equals(name)) {
                    modulus = Helpers.parsePositiveBigInt(JsonHelper.nextString(p, ctxt));
                    continue;
                }
                if ("x".equals(name)) {
                    x = Helpers.parsePositiveBigInt(JsonHelper.nextString(p, ctxt));
                    continue;
                }
                if ("y".equals(name)) {
                    y = Helpers.parsePositiveBigInt(JsonHelper.nextString(p, ctxt));
                    continue;
                }
                log.warn("Invalid attribute [{}] in JSON Web Key.", (Object)name);
                p.nextToken();
                p.skipChildren();
            }
            JsonHelper.endObject(p, ctxt);
            if (keyType == KeyType.RSA) {
                if (exponent == null || modulus == null) {
                    throw new IllegalArgumentException("Public RSA JSON Web Key with missing modulus or exponent.");
                }
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                    RSAPublicKeySpec rpks = new RSAPublicKeySpec(modulus, exponent);
                    pubKey = keyFactory.generatePublic(rpks);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                    throw new IllegalArgumentException("Public RSA JSON Web Key could not be instantiated.", e);
                }
                if (algorithm == null) {
                    algorithm = Algorithm.RS256;
                }
            } else {
                if (keyType != KeyType.EC2) throw new IllegalArgumentException("Invalid JSON Web Key type [" + String.valueOf((Object)keyType) + "].");
                if (x == null || y == null) {
                    throw new IllegalArgumentException("EC JSON Web Key with missing x or y base.");
                }
                try {
                    AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
                    algorithmParameters.init(new ECGenParameterSpec(curve.getJceType()));
                    ECParameterSpec ecps = algorithmParameters.getParameterSpec(ECParameterSpec.class);
                    ECPoint w = new ECPoint(x, y);
                    ECPublicKeySpec ecpks = new ECPublicKeySpec(w, ecps);
                    KeyFactory kf = KeyFactory.getInstance("EC");
                    pubKey = kf.generatePublic(ecpks);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Public EC JSON Web Key could not be instantiated.", exception);
                }
                if (algorithm == null) {
                    algorithm = curve.getAlgorithm();
                }
            }
            if (certificateChain != null && certificateChain.length == 0) {
                throw new IllegalArgumentException("Public JSON Web Key has an empty X.509 certificate chain.");
            }
            if (certificateThumbprint == null) {
                if (certificateChain != null) {
                    certificateThumbprint = Helpers.getSha1Fingerprint((Certificate)certificateChain[0]);
                }
            } else {
                byte[] byArray;
                if (certificateChain == null && certificateUrl == null) {
                    throw new IllegalArgumentException("Public JSON Web Key has an empty X.509 certificate chain but a given thumbprint.");
                }
                if (certificateChain != null && !Arrays.equals(certificateThumbprint, byArray = Helpers.getSha1Fingerprint((Certificate)certificateChain[0]))) {
                    throw new IllegalArgumentException("Public JSON Web Key has a X.509 certificate and a differing x5t thumbprint.");
                }
            }
            if (certificateThumbprintSha256 == null) {
                if (certificateChain != null) {
                    certificateThumbprintSha256 = Helpers.getSha256Fingerprint((Certificate)certificateChain[0]);
                }
            } else {
                byte[] byArray;
                if (certificateChain == null && certificateUrl == null) {
                    throw new IllegalArgumentException("Public JSON Web Key has an empty X.509 certificate chain but a given SHA-256 thumbprint.");
                }
                if (certificateChain != null && !Arrays.equals(certificateThumbprintSha256, byArray = Helpers.getSha256Fingerprint((Certificate)certificateChain[0]))) {
                    throw new IllegalArgumentException("Public JSON Web Key has a X.509 certificate and a differing x5t#S256 thumbprint.");
                }
            }
            if (keyOperations == null) {
                if ("enc".equals(usage)) {
                    keyOperations = new KeyOperation[]{KeyOperation.encrypt, KeyOperation.wrapKey};
                } else {
                    if (usage != null && !"sig".equals(usage)) throw new IllegalArgumentException("JSON Web Key has invalid key usage [" + usage + "]");
                    keyOperations = new KeyOperation[]{KeyOperation.verify};
                }
            } else if (usage != null) {
                log.warn("JSON Web Key has key usage [" + usage + "] will be ignored because of the presence of key_ops.");
            }
            if (certificateChain != null && !Helpers.pubKeysAreEqual(pubKey, publicKey = certificateChain[0].getPublicKey())) {
                throw new IllegalArgumentException("Public JSON Web Key has a X.509 certificate with a non-matching public key.");
            }
            PubKeyInfo pubKeyInfo = new PubKeyInfo(keyId, keyType, curve, algorithm, keyOperations, pubKey);
            return new JWKPubKey(pubKeyInfo, certificateUrl, certificateChain, certificateThumbprint, certificateThumbprintSha256);
        }
    }

    private static class JWKPubKeySerializer
    extends JsonSerializer<JWKPubKey> {
        private JWKPubKeySerializer() {
        }

        public Class<JWKPubKey> handledType() {
            return JWKPubKey.class;
        }

        public void serialize(JWKPubKey pubKey, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            PubKeyInfo keyInfo = pubKey.getPubKeyInfo();
            gen.writeFieldName("kid");
            gen.writeString(keyInfo.getKeyId());
            gen.writeFieldName("kty");
            gen.writeString(keyInfo.getKeyType().getJwkType());
            boolean mayVerify = false;
            boolean mayEncrypt = false;
            if (keyInfo.getKeyOperations() != null) {
                gen.writeFieldName("key_ops");
                gen.writeStartArray();
                for (KeyOperation keyOperation : keyInfo.getKeyOperations()) {
                    gen.writeString(keyOperation.toString());
                    if (keyOperation == KeyOperation.verify) {
                        mayVerify = true;
                    }
                    if (keyOperation != KeyOperation.encrypt && keyOperation != KeyOperation.wrapKey) continue;
                    mayEncrypt = true;
                }
                gen.writeEndArray();
            }
            gen.writeFieldName("use");
            gen.writeString(mayVerify ? "sig" : (mayEncrypt ? "enc" : "sig"));
            gen.writeFieldName("alg");
            gen.writeString(keyInfo.getAlgorithm().toString());
            if (keyInfo.getKeyType() == KeyType.RSA) {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)keyInfo.getPublicKey();
                gen.writeFieldName("n");
                gen.writeString(Helpers.formatPositiveBigInt(rSAPublicKey.getModulus()));
                gen.writeFieldName("e");
                gen.writeString(Helpers.formatPositiveBigInt(rSAPublicKey.getPublicExponent()));
            } else if (keyInfo.getKeyType() == KeyType.EC2) {
                ECPublicKey eCPublicKey = (ECPublicKey)keyInfo.getPublicKey();
                gen.writeFieldName("crv");
                gen.writeString(keyInfo.getCurve().getJwkType());
                gen.writeFieldName("x");
                gen.writeString(Helpers.formatPositiveBigInt(eCPublicKey.getW().getAffineX()));
                gen.writeFieldName("y");
                gen.writeString(Helpers.formatPositiveBigInt(eCPublicKey.getW().getAffineY()));
            } else {
                throw new IllegalArgumentException("Invalid JSON Web Key type [" + String.valueOf((Object)keyInfo.getKeyType()) + "].");
            }
            if (pubKey.getCertificateUrl() != null) {
                gen.writeFieldName("x5u");
                gen.writeString(pubKey.getCertificateUrl());
            }
            if (pubKey.getCertificateThumbprint() != null) {
                gen.writeFieldName("x5t");
                gen.writeString(Helpers.formatBase64(pubKey.getCertificateThumbprint()));
            }
            if (pubKey.getCertificateThumbprintSha256() != null) {
                gen.writeFieldName("x5t#S256");
                gen.writeString(Helpers.formatBase64(pubKey.getCertificateThumbprintSha256()));
            }
            if (pubKey.getCertificateChain() != null) {
                gen.writeFieldName("x5c");
                gen.writeStartArray();
                for (Certificate certificate : pubKey.getCertificateChain()) {
                    try {
                        gen.writeString(Base64.getEncoder().encodeToString(certificate.getEncoded()));
                    }
                    catch (CertificateEncodingException e) {
                        throw new IllegalArgumentException("JWK public key with unencodable certificate in chain.", e);
                    }
                }
                gen.writeEndArray();
            }
            gen.writeEndObject();
        }
    }

    private static class JWKPubKeyListHolder
    implements Serializable {
        private static final long serialVersionUID = -8420183466318633281L;
        private List<JWKPubKey> keys;

        private JWKPubKeyListHolder() {
        }

        public List<JWKPubKey> getKeys() {
            return this.keys;
        }

        public void setKeys(List<JWKPubKey> keys) {
            this.keys = keys;
        }
    }
}

