/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public abstract class JsonHelper {
    public static void beginObject(JsonParser parser, String ctxt) throws IOException {
        if (parser.currentToken() == JsonToken.START_OBJECT) {
            return;
        }
        if (parser.nextToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Expected JSON BEGIN_OBJECT for [" + ctxt + "/" + String.valueOf(parser.currentTokenLocation()) + "]");
        }
    }

    public static void endObject(JsonParser parser, String ctxt) throws IOException {
        if (parser.currentToken() != JsonToken.END_OBJECT) {
            throw new IllegalStateException("Expected JSON END_OBJECT for [" + ctxt + "/" + String.valueOf(parser.currentTokenLocation()) + "]");
        }
    }

    public static boolean beginObjectOrNull(JsonParser parser, String ctxt) throws IOException {
        JsonToken token = parser.nextToken();
        if (token == JsonToken.START_OBJECT) {
            return true;
        }
        if (token != JsonToken.VALUE_NULL) {
            throw new IllegalStateException("Expected JSON BEGIN_OBJECT or VALUE_NULL for [" + ctxt + "/" + String.valueOf(parser.currentTokenLocation()) + "]");
        }
        return false;
    }

    public static void beginArray(JsonParser parser, String ctxt) throws IOException {
        if (parser.nextToken() != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Expected JSON BEGIN_ARRAY for [" + ctxt + "/" + String.valueOf(parser.currentTokenLocation()) + "]");
        }
    }

    public static void endArray(JsonParser parser, String ctxt) throws IOException {
        if (parser.currentToken() != JsonToken.END_ARRAY) {
            throw new IllegalStateException("Expected JSON END_ARRAY for [" + ctxt + "/" + String.valueOf(parser.currentTokenLocation()) + "]");
        }
    }

    public static String nextName(JsonParser parser, String ctxt) throws IOException {
        JsonToken token = parser.nextToken();
        if (token == JsonToken.FIELD_NAME) {
            return parser.currentName();
        }
        if (token != JsonToken.END_OBJECT) {
            throw new IllegalStateException("Expected JSON FIELD_NAME or END_OBJECT for [" + ctxt + "/" + String.valueOf(parser.currentTokenLocation()) + "]");
        }
        return null;
    }

    public static String nextString(JsonParser parser, String ctxt) throws IOException {
        if (parser.nextToken() != JsonToken.VALUE_STRING) {
            throw new IllegalStateException("Expected VALUE_STRING for [" + ctxt + "/" + String.valueOf(parser.currentTokenLocation()) + "]");
        }
        return parser.getText();
    }

    public static long nextLong(JsonParser parser, String ctxt) throws IOException {
        if (parser.nextToken() != JsonToken.VALUE_NUMBER_INT) {
            throw new IllegalStateException("Expected VALUE_NUMBER_INT for [" + ctxt + "/" + String.valueOf(parser.currentTokenLocation()) + "]");
        }
        return parser.getLongValue();
    }
}

