/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.cose;

import java.util.HashMap;
import java.util.Map;
import org.clazzes.login.jbo.common.KeyType;

public enum COSEKeyTypeParameter {
    OKP_CRV(KeyType.OKP, -1),
    OKP_X(KeyType.OKP, -2),
    OKP_D(KeyType.OKP, -4),
    EC2_CRV(KeyType.EC2, -1),
    EC2_X(KeyType.EC2, -2),
    EC2_Y(KeyType.EC2, -3),
    EC2_D(KeyType.EC2, -4),
    RSA_N(KeyType.RSA, -1),
    RSA_E(KeyType.RSA, -2),
    RSA_D(KeyType.RSA, -3),
    RSA_P(KeyType.RSA, -4),
    RSA_Q(KeyType.RSA, -5),
    RSA_DP(KeyType.RSA, -6),
    RSA_DQ(KeyType.RSA, -7),
    RSA_QINV(KeyType.RSA, -8),
    RSA_OTHER(KeyType.RSA, -9),
    RSA_R_I(KeyType.RSA, -10),
    RSA_D_I(KeyType.RSA, -11),
    RSA_T_I(KeyType.RSA, -12),
    Symmetric_K(KeyType.Symmetric, -1);

    private static final Map<Integer, COSEKeyTypeParameter> paramsByKeyTypeAndLabel;
    private final KeyType keyType;
    private final int label;

    public static final COSEKeyTypeParameter getByKeyTypeAndLabel(KeyType keyType, int label) {
        if (keyType == null) {
            throw new NullPointerException("keyType must not be null.");
        }
        if (label > -1 || label < -255) {
            throw new IllegalArgumentException("key type paramter label must be a negative number in the range [-255,-1].");
        }
        COSEKeyTypeParameter p = paramsByKeyTypeAndLabel.get(keyType.getValue() * 256 + label);
        if (p == null) {
            throw new IllegalArgumentException("The label [" + label + "] is not a known parameter for COSE key type [" + String.valueOf((Object)keyType) + "].");
        }
        return p;
    }

    private COSEKeyTypeParameter(KeyType keyType, int label) {
        this.keyType = keyType;
        this.label = label;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public int getLabel() {
        return this.label;
    }

    static {
        paramsByKeyTypeAndLabel = new HashMap<Integer, COSEKeyTypeParameter>();
        for (COSEKeyTypeParameter p : COSEKeyTypeParameter.values()) {
            paramsByKeyTypeAndLabel.put(p.getKeyType().getValue() * 256 + p.getLabel(), p);
        }
    }
}

