/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.common;

import java.security.PublicKey;
import java.util.Arrays;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.CurveType;
import org.clazzes.login.jbo.common.KeyOperation;
import org.clazzes.login.jbo.common.KeyType;

public class PubKeyInfo {
    private final String keyId;
    private final KeyType keyType;
    private final CurveType curve;
    private final Algorithm algorithm;
    private final KeyOperation[] keyOperations;
    private final PublicKey publicKey;

    public PubKeyInfo(String keyId, KeyType keyType, CurveType curve, Algorithm algorithm, KeyOperation[] keyOperations, PublicKey publicKey) {
        this.keyId = keyId;
        this.keyType = keyType;
        this.curve = curve;
        this.algorithm = algorithm;
        this.keyOperations = keyOperations;
        this.publicKey = publicKey;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public CurveType getCurve() {
        return this.curve;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getJceAlgorithm() {
        String ret = this.algorithm.getJceName();
        if (ret == null && this.curve != null) {
            ret = this.curve.getJwkType();
        }
        return ret;
    }

    public KeyOperation[] getKeyOperations() {
        return this.keyOperations;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String toString() {
        return "PubKeyInfo [keyId=" + this.keyId + ", keyType=" + String.valueOf((Object)this.keyType) + ", curve=" + String.valueOf((Object)this.curve) + ", algorithm=" + String.valueOf((Object)this.algorithm) + ", keyOperations=" + Arrays.toString((Object[])this.keyOperations) + ", publicKey=" + String.valueOf(this.publicKey) + "]";
    }
}

