/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.common;

import java.util.HashMap;
import java.util.Map;

public enum KeyType {
    OKP(1, null),
    EC2(2, "EC"),
    RSA(3, "RSA"),
    Symmetric(4, null);

    private static final Map<Integer, KeyType> typeByValue;
    private static final Map<String, KeyType> typeByJwkType;
    private final int value;
    private final String jwkType;

    public static KeyType getByValue(Integer value) {
        KeyType ret = typeByValue.get(value);
        if (ret == null) {
            throw new IllegalArgumentException("The value [" + value + "] is not a known COSE key type.");
        }
        return ret;
    }

    public static KeyType getByJwkType(String jwkType) {
        KeyType ret = typeByJwkType.get(jwkType);
        if (ret == null) {
            throw new IllegalArgumentException("The JWK key tyoe [" + jwkType + "] is unknown.");
        }
        return ret;
    }

    private KeyType(int value, String jwkType) {
        this.value = value;
        this.jwkType = jwkType;
    }

    public int getValue() {
        return this.value;
    }

    public String getJwkType() {
        return this.jwkType;
    }

    static {
        typeByValue = new HashMap<Integer, KeyType>();
        typeByJwkType = new HashMap<String, KeyType>();
        for (KeyType e : KeyType.values()) {
            typeByValue.put(e.getValue(), e);
            if (e.getJwkType() == null) continue;
            typeByJwkType.put(e.getJwkType(), e);
        }
    }
}

