/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.common;

import java.util.HashMap;
import java.util.Map;

public enum KeyOperation {
    sign(1),
    verify(2),
    encrypt(3),
    decrypt(4),
    wrapKey(5),
    unwrapKey(6),
    deriveKey(7),
    deriveBits(8),
    macCreate(9),
    macVerify(10);

    private static final Map<Integer, KeyOperation> keyOpByValue;
    private final int value;

    public static KeyOperation getByValue(Integer value) {
        KeyOperation ret = keyOpByValue.get(value);
        if (ret == null) {
            throw new IllegalArgumentException("The value [" + value + "] is not a supported KeyOperation.");
        }
        return ret;
    }

    private KeyOperation(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    static {
        keyOpByValue = new HashMap<Integer, KeyOperation>();
        for (KeyOperation e : KeyOperation.values()) {
            keyOpByValue.put(e.getValue(), e);
        }
    }
}

