/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.common;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.HexFormat;

public class Helpers {
    public static final byte[] parseBase64(String b64String) {
        Object x = b64String.replace('-', '+').replace('_', '/');
        switch (((String)x).length() % 4) {
            case 2: {
                x = (String)x + "==";
                break;
            }
            case 3: {
                x = (String)x + "=";
            }
        }
        return Base64.getDecoder().decode((String)x);
    }

    public static final BigInteger parsePositiveBigInt(String b64String) {
        return new BigInteger(1, Helpers.parseBase64(b64String));
    }

    public static final String formatBase64(byte[] data) {
        if (data == null) {
            return null;
        }
        return Base64.getUrlEncoder().encodeToString(data);
    }

    public static final String formatHex(byte[] data) {
        if (data == null) {
            return null;
        }
        return HexFormat.of().formatHex(data);
    }

    public static final String formatPositiveBigInt(BigInteger bi) {
        byte[] data = bi.toByteArray();
        if (data[0] == 0) {
            return Helpers.formatBase64(Arrays.copyOfRange(data, 1, data.length));
        }
        return Helpers.formatBase64(data);
    }

    public static final String[] parseScope(String scope) {
        if (scope == null) {
            return new String[0];
        }
        String trimmed = scope.trim();
        if (trimmed.isEmpty()) {
            return new String[0];
        }
        Object[] scopes = trimmed.split("\\s+");
        Arrays.sort(scopes);
        return scopes;
    }

    public static final byte[][] splitToken(String tokenString, int limit) {
        String[] parts = new String[limit];
        int nparts = 0;
        int lastPos = 0;
        for (int i = 0; i < tokenString.length(); ++i) {
            if (tokenString.charAt(i) != '.') continue;
            parts[nparts] = tokenString.substring(lastPos, i);
            if (++nparts >= limit) {
                throw new IllegalArgumentException("Token contains more than [" + limit + "] parts.");
            }
            lastPos = i + 1;
        }
        parts[nparts] = tokenString.substring(lastPos);
        byte[][] ret = new byte[++nparts][];
        for (int i = 0; i < nparts; ++i) {
            ret[i] = Helpers.parseBase64(parts[i]);
        }
        return ret;
    }

    public static final byte[] getSha1Fingerprint(Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(cert.getEncoded());
            return md.digest();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not generate SHA-1 tumbprint for X-509 certificate.", e);
        }
    }

    public static final byte[] getSha256Fingerprint(Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(cert.getEncoded());
            return md.digest();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not generate SHA-256 tumbprint for X-509 certificate.", e);
        }
    }

    public static final boolean pubKeysAreEqual(PublicKey a, PublicKey b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return Arrays.equals(a.getEncoded(), b.getEncoded());
    }
}

