/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.common;

import java.util.HashMap;
import java.util.Map;
import org.clazzes.login.jbo.common.Algorithm;

public enum CurveType {
    P_256(1, "P-256", "secp256r1", "1.2.840.10045.3.1.7", Algorithm.ES256),
    P_384(2, "P-384", "secp384r1", "1.3.132.0.34", Algorithm.ES384),
    P_521(3, "P-521", "secp521r1", "1.3.132.0.35", Algorithm.ES512),
    X25519(4, "X25519", null, null, null),
    X448(5, "X448", null, null, null),
    Ed25519(6, "Ed25519", null, null, Algorithm.EdDSA),
    Ed448(7, "Ed448", null, null, Algorithm.EdDSA);

    private static final Map<Integer, CurveType> curvesByValue;
    private static final Map<String, CurveType> curvesByJwkType;
    private static final Map<String, CurveType> curvesByJceType;
    private static final Map<String, CurveType> curvesByOid;
    private final int value;
    private final String jwkType;
    private final String jceType;
    private final String oid;
    private final Algorithm algorithm;

    public static CurveType getByValue(Integer value) {
        CurveType ret = curvesByValue.get(value);
        if (ret == null) {
            throw new IllegalArgumentException("The value [" + value + "] is not a known COSE Elliptic Curve.");
        }
        return ret;
    }

    public static CurveType getByJwkType(String jwkType) {
        CurveType ret = curvesByJwkType.get(jwkType);
        if (ret == null) {
            throw new IllegalArgumentException("The JWK name [" + jwkType + "] is not a known Elliptic Curve.");
        }
        return ret;
    }

    public static CurveType getByJceType(String jceType) {
        CurveType ret = curvesByJceType.get(jceType);
        if (ret == null) {
            throw new IllegalArgumentException("The JCE name [" + jceType + "] is not a known Elliptic Curve.");
        }
        return ret;
    }

    public static CurveType getByOid(String oid) {
        CurveType ret = curvesByOid.get(oid);
        if (ret == null) {
            throw new IllegalArgumentException("The OID [" + oid + "] is not a known Elliptic Curve.");
        }
        return ret;
    }

    private CurveType(int value, String jwkType, String jceType, String oid, Algorithm algorithm) {
        this.value = value;
        this.jwkType = jwkType;
        this.jceType = jceType;
        this.oid = oid;
        this.algorithm = algorithm;
    }

    public int getValue() {
        return this.value;
    }

    public String getJwkType() {
        return this.jwkType;
    }

    public String getJceType() {
        return this.jceType;
    }

    public String getOid() {
        return this.oid;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    static {
        curvesByValue = new HashMap<Integer, CurveType>();
        curvesByJwkType = new HashMap<String, CurveType>();
        curvesByJceType = new HashMap<String, CurveType>();
        curvesByOid = new HashMap<String, CurveType>();
        for (CurveType e : CurveType.values()) {
            curvesByValue.put(e.getValue(), e);
            curvesByJwkType.put(e.getJwkType(), e);
            if (e.getOid() != null) {
                curvesByOid.put(e.getOid(), e);
            }
            if (e.getJceType() == null) continue;
            curvesByJceType.put(e.getJceType(), e);
        }
    }
}

