/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.common;

import java.util.HashMap;
import java.util.Map;
import org.clazzes.login.jbo.common.KeyType;

public enum Algorithm {
    RS1(-65535, "SHA1withRSA", "SHA-1", KeyType.RSA),
    RS512(-259, "SHA512withRSA", "SHA-512", KeyType.RSA),
    RS384(-258, "SHA384withRSA", "SHA-384", KeyType.RSA),
    RS256(-257, "SHA256withRSA", "SHA-256", KeyType.RSA),
    RSAES_OAEP_SHA_512(-42, "OAEPWithSHA-512AndMGF1Padding", "SHA-512", KeyType.RSA),
    RSAES_OAEP_SHA_256(-41, "OAEPWithSHA-256AndMGF1Padding", "SHA-256", KeyType.RSA),
    RSAES_OAEP_SHA_1(-40, "OAEPWithSHA-1AndMGF1Padding", "SHA-1", KeyType.RSA),
    PS512(-39, "SHA512withRSAandMGF1", "SHA-512", KeyType.RSA),
    PS384(-38, "SHA384withRSAandMGF1", "SHA-384", KeyType.RSA),
    PS256(-37, "SHA256withRSAandMGF1", "SHA-256", KeyType.RSA),
    ES512(-36, "SHA512withECDSA", "SHA-512", KeyType.EC2),
    ES384(-35, "SHA384withECDSA", "SHA-384", KeyType.EC2),
    ES256(-7, "SHA256withECDSA", "SHA-256", KeyType.EC2),
    EdDSA(-8, null, null, KeyType.OKP);

    private static final Map<Integer, Algorithm> algosByValue;
    private static final Map<String, Algorithm> algosByJceName;
    private final int value;
    private final String jceName;
    private final String hashName;
    private final KeyType keyType;

    public static Algorithm getByValue(Integer value) {
        Algorithm ret = algosByValue.get(value);
        if (ret == null) {
            throw new IllegalArgumentException("The value [" + value + "] is not a supported COSE cryptographic algorithm.");
        }
        return ret;
    }

    private Algorithm(int value, String jceName, String hashName, KeyType keyType) {
        this.value = value;
        this.jceName = jceName;
        this.hashName = hashName;
        this.keyType = keyType;
    }

    public int getValue() {
        return this.value;
    }

    public String getJceName() {
        return this.jceName;
    }

    public String getHashName() {
        return this.hashName;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    static {
        algosByValue = new HashMap<Integer, Algorithm>();
        algosByJceName = new HashMap<String, Algorithm>();
        for (Algorithm e : Algorithm.values()) {
            algosByValue.put(e.getValue(), e);
            if (e.getJceName() == null) continue;
            algosByJceName.put(e.getJceName(), e);
        }
    }
}

