/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jbo.bc;

import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.BigIntegers;
import org.clazzes.login.jbo.common.Algorithm;
import org.clazzes.login.jbo.common.CurveType;
import org.clazzes.login.jbo.common.IExtensionConsumer;
import org.clazzes.login.jbo.common.KeyOperation;
import org.clazzes.login.jbo.common.KeyType;
import org.clazzes.login.jbo.common.PubKeyInfo;

public abstract class BCTools {
    private static final KeyOperation[] defaultKeyOperations = new KeyOperation[]{KeyOperation.verify};
    private static final ASN1ObjectIdentifier id_edwards_curve_algs = new ASN1ObjectIdentifier("1.3.101");
    private static final ASN1ObjectIdentifier id_Ed25519 = id_edwards_curve_algs.branch("112").intern();
    private static final ASN1ObjectIdentifier id_Ed448 = id_edwards_curve_algs.branch("113").intern();

    public static final ECPoint decompressPoint(CurveType ct, BigInteger x, boolean ytilde) {
        if (x == null) {
            return ECPoint.POINT_INFINITY;
        }
        X9ECParameters p = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(ct.getOid()));
        ECCurve curve = p.getCurve();
        int expectedLength = (curve.getFieldSize() + 7) / 8;
        byte[] encoded = new byte[expectedLength + 1];
        encoded[0] = (byte)(ytilde ? 3 : 2);
        System.arraycopy(BigIntegers.asUnsignedByteArray((int)expectedLength, (BigInteger)x), 0, encoded, 1, expectedLength);
        org.bouncycastle.math.ec.ECPoint bcPoint = p.getCurve().decodePoint(encoded);
        return new ECPoint(bcPoint.getAffineXCoord().toBigInteger(), bcPoint.getAffineYCoord().toBigInteger());
    }

    public static final byte[] encodePoint(CurveType ct, ECPoint point) {
        if (point == null || point.equals(ECPoint.POINT_INFINITY)) {
            return new byte[1];
        }
        X9ECParameters p = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(ct.getOid()));
        ECCurve curve = p.getCurve();
        int expectedLength = (curve.getFieldSize() + 7) / 8;
        byte[] encoded = new byte[2 * expectedLength + 1];
        encoded[0] = 4;
        System.arraycopy(BigIntegers.asUnsignedByteArray((int)expectedLength, (BigInteger)point.getAffineX()), 0, encoded, 1, expectedLength);
        System.arraycopy(BigIntegers.asUnsignedByteArray((int)expectedLength, (BigInteger)point.getAffineY()), 0, encoded, expectedLength + 1, expectedLength);
        return encoded;
    }

    public static PubKeyInfo getPubKeyInfo(Algorithm algorithm, String keyId, X509Certificate certificate) throws CertificateEncodingException {
        return BCTools.getPubKeyInfo(algorithm, keyId, certificate, null);
    }

    public static PubKeyInfo getPubKeyInfo(Algorithm algorithm, String keyId, X509Certificate certificate, IExtensionConsumer extensionConsumer) throws CertificateEncodingException {
        KeyOperation[] keyOperations;
        CurveType curveType;
        KeyType keyType;
        Certificate cert = Certificate.getInstance((Object)certificate.getEncoded());
        TBSCertificate tbs = cert.getTBSCertificate();
        KeyUsage ku = KeyUsage.fromExtensions((Extensions)tbs.getExtensions());
        SubjectPublicKeyInfo spki = tbs.getSubjectPublicKeyInfo();
        ASN1ObjectIdentifier algorithmId = spki.getAlgorithm().getAlgorithm();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)algorithmId)) {
            ASN1Encodable params = spki.getAlgorithm().getParameters();
            if (!(params instanceof ASN1ObjectIdentifier)) {
                throw new IllegalArgumentException("EC public key without a curve parameter sepcified.");
            }
            keyType = KeyType.EC2;
            curveType = CurveType.getByOid(params.toString());
            if (algorithm == null) {
                algorithm = curveType.getAlgorithm();
            } else if (algorithm != curveType.getAlgorithm()) {
                throw new IllegalArgumentException("Algorithm [" + String.valueOf((Object)algorithm) + "] is not compatible with EC curve [" + String.valueOf((Object)curveType) + "].");
            }
        } else if (PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)algorithmId)) {
            keyType = KeyType.RSA;
            curveType = null;
            if (algorithm == null) {
                algorithm = Algorithm.RS256;
            } else if (algorithm.getKeyType() != KeyType.RSA) {
                throw new IllegalArgumentException("Algorithm [" + String.valueOf((Object)algorithm) + "] is not compatible with RSA public key.");
            }
        } else if (id_Ed25519.equals((ASN1Primitive)algorithmId)) {
            keyType = KeyType.OKP;
            curveType = CurveType.Ed25519;
            if (algorithm == null) {
                algorithm = Algorithm.EdDSA;
            } else if (algorithm != Algorithm.EdDSA) {
                throw new IllegalArgumentException("Algorithm [" + String.valueOf((Object)algorithm) + "] is not compatible with EdDSA curve [" + String.valueOf((Object)curveType) + "].");
            }
        } else if (id_Ed448.equals((ASN1Primitive)algorithmId)) {
            keyType = KeyType.OKP;
            curveType = CurveType.Ed448;
            if (algorithm == null) {
                algorithm = Algorithm.EdDSA;
            } else if (algorithm != Algorithm.EdDSA) {
                throw new IllegalArgumentException("Algorithm [" + String.valueOf((Object)algorithm) + "] is not compatible with EdDSA curve [" + String.valueOf((Object)curveType) + "].");
            }
        } else {
            throw new IllegalArgumentException("Unknown certificate public key algorithm [" + String.valueOf(algorithmId) + "].");
        }
        if (ku == null) {
            keyOperations = defaultKeyOperations;
        } else {
            ArrayList<KeyOperation> usages = new ArrayList<KeyOperation>();
            if (ku.hasUsages(128) || ku.hasUsages(64)) {
                usages.add(KeyOperation.verify);
            }
            if (ku.hasUsages(16)) {
                usages.add(KeyOperation.encrypt);
            }
            if (ku.hasUsages(32)) {
                usages.add(KeyOperation.wrapKey);
            }
            keyOperations = usages.toArray(new KeyOperation[usages.size()]);
        }
        if (extensionConsumer != null) {
            Iterator<String> it = extensionConsumer.getSupportedOids();
            while (it.hasNext()) {
                String oid = it.next();
                Extension ext = tbs.getExtensions().getExtension(new ASN1ObjectIdentifier(oid));
                if (ext == null) continue;
                switch (extensionConsumer.getExtensionFormat(oid)) {
                    case BIT_STRING: {
                        ASN1BitString bs = (ASN1BitString)ext.getParsedValue();
                        extensionConsumer.consumeBitString(oid, bs.getBytes(), bs.getPadBits());
                        break;
                    }
                    case OCTET_STRING: {
                        ASN1OctetString os = (ASN1OctetString)ext.getParsedValue();
                        extensionConsumer.consumeOctetString(oid, os.getOctets());
                        break;
                    }
                    case RAW_DATA: {
                        extensionConsumer.consumeOctetString(oid, ext.getExtnValue().getOctets());
                    }
                }
            }
        }
        return new PubKeyInfo(keyId, keyType, curveType, algorithm, keyOperations, certificate.getPublicKey());
    }
}

