/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 15.03.2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.webauthn;

import java.io.Serializable;
import java.util.List;

/**
 * <code>
 * {
 *   "challenge": "R06lTSzbXCv3qnwa68x87B7FIw6k3DecF03WyWAgwv8=",
 *   "allowCredentials": [
 *     {
 *       "id": "EnBpsgHvdK59IxqoQJTp+8sk8G5MVTwU",
 *       "type: "public-key"
 *     },
 *     {
 *       "id": "Pdb8FA0/DOqq6uLyQKSWxd6cM3JeXWkw",
 *       "type": "public-key"
 *     }
 *   ],
 *   "rpId": "demo.yubico.com",
 *   "timeout": 90000,
 *   "userVerification": "discouraged"
 * }
 * </code>
 */
public class PublicKeyGetOptions implements Serializable {
    
    private static final long serialVersionUID = -1199874660328579112L;

    private final byte[] challenge;
    private final List<CredentialRef> allowCredentials;
    private final String rpId;
    private final int timeout;
    private final String userVerification;
    
    public PublicKeyGetOptions(byte[] challenge,
            List<CredentialRef> excludeCredentials,
            String rpId,
            int timeout, String userVerification) {
        super();
        this.challenge = challenge;
        this.allowCredentials = excludeCredentials;
        this.rpId = rpId;
        this.timeout = timeout;
        this.userVerification = userVerification;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public List<CredentialRef> getAllowCredentials() {
        return this.allowCredentials;
    }

    public String getRpId() {
        return this.rpId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUserVerification() {
        return this.userVerification;
    }
    
}
