/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 15.03.2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.webauthn;

import java.io.Serializable;
import java.util.List;

/**
 * <code>
 * {
 *   "attestation": "direct",
 *   "authenticatorSelection": {
 *     "requireResidentKey": false,
 *     "userVerification": "discouraged"
 *   },
 *   "challenge": "R06lTSzbXCv3qnwa68x87B7FIw6k3DecF03WyWAgwv8=",
 *   "excludeCredentials": [
 *     {
 *       "id": "EnBpsgHvdK59IxqoQJTp+8sk8G5MVTwU",
 *       "type: "public-key"
 *     },
 *     {
 *       "id": "Pdb8FA0/DOqq6uLyQKSWxd6cM3JeXWkw",
 *       "type": "public-key"
 *     }
 *   ],
 *   "pubKeyCredParams": [
 *     {
 *       "alg": -7,
 *        "type": "public-key"
 *     },
 *     {
 *       "alg": -257,
 *       "type": "public-key"
 *     }
 *   ],
 *   "rp": {
 *     "id": "demo.yubico.com",
 *     "name": "YubicoDemo"
 *   },
 *   "timeout": 90000,
 *   "user": {
 *     "displayName": "Yubico demo user",
 *     "id": "Y6Svbygnp+Mg+oZ6LxXQCmng3q9iNbFyX14OSsakkb4=",
 *     "name": "Yubico demo user"
 *   }
 * }
 * </code>
 */
public class PublicKeyCreationOptions implements Serializable {
    
    private static final long serialVersionUID = 270912867322507574L;
   
    private final String attestation;
    private final AuthenticatorSelection authenticatorSelection;
    private final byte[] challenge;
    private final List<CredentialRef> excludeCredentials;
    private final List<PubKeyCredParam> pubKeyCredParams;
    private final RelyingParty rp;
    private final int timeout;
    private final WebAuthnUser user;
    
    public PublicKeyCreationOptions(String attestation,
            AuthenticatorSelection authenticatorSelection, byte[] challenge,
            List<CredentialRef> excludeCredentials,
            List<PubKeyCredParam> pubKeyCredParams, RelyingParty rp,
            int timeout, WebAuthnUser user) {
        super();
        this.attestation = attestation;
        this.authenticatorSelection = authenticatorSelection;
        this.challenge = challenge;
        this.excludeCredentials = excludeCredentials;
        this.pubKeyCredParams = pubKeyCredParams;
        this.rp = rp;
        this.timeout = timeout;
        this.user = user;
    }

    public String getAttestation() {
        return this.attestation;
    }

    public AuthenticatorSelection getAuthenticatorSelection() {
        return this.authenticatorSelection;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public List<CredentialRef> getExcludeCredentials() {
        return this.excludeCredentials;
    }

    public List<PubKeyCredParam> getPubKeyCredParams() {
        return this.pubKeyCredParams;
    }

    public RelyingParty getRp() {
        return this.rp;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public WebAuthnUser getUser() {
        return this.user;
    }
    
}
