/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 15.03.2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.webauthn;

import java.io.Serializable;

import org.clazzes.login.jbo.common.Algorithm;

/**
 * <code>
 * {
 *   "alg": -7,
 *   "type": "public-key"
 * }
 * </code>
 */
public class PubKeyCredParam implements Serializable {

    private static final long serialVersionUID = 7909967043869532098L;

    private final int alg;
    private final String type;
    
    public PubKeyCredParam(Algorithm algorithm) {
        this(algorithm.getValue(),Constants.PUBLIC_KEY_TYPE);
    }

    public PubKeyCredParam(int alg, String type) {
        super();
        this.alg = alg;
        this.type = type;
    }

    public int getAlg() {
        return this.alg;
    }

    public String getType() {
        return this.type;
    }
    
}
