/***********************************************************
 *
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jbo.webauthn;

import java.io.IOException;
import java.util.Base64;

import org.clazzes.login.jbo.common.Helpers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

/**
 * <p>Serialize a byte array as javascript snippet, which creates an
 * <code>Uint8Array</code> on the fly.</p>
 *
 * <p>This might be needed by client libraries, which write WebAuthn payloads
 * to javascript.</p>
 */
public class JsByteArraySerializer extends JsonSerializer<byte[]> {

    @Override
    public Class<byte[]> handledType() {
        return byte[].class;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {

        String b64 = Base64.getEncoder().encodeToString(value);

        gen.writeRawValue("Uint8Array.from(window.atob(\""+b64+"\"), c=>c.charCodeAt(0))");
    }

}
