/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 15.03.2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.webauthn;

import java.io.Serializable;

/**
 * A reference to an credentials as used in the <code>excludeCredentials</code>
 * parameter.
 * <code>
 * {
 *   "id": "EnBpsgHvdK59IxqoQJTp+8sk8G5MVTwU",
 *   "type: "public-key"
 * }
 * </code>
 */
public class CredentialRef implements Serializable {

    private static final long serialVersionUID = 6078177253083304753L;

    private final byte[] id;
    private final String type;
    
    public CredentialRef(byte[] id) {
        this(id,Constants.PUBLIC_KEY_TYPE);
    }
    
    public CredentialRef(byte[] id, String type) {
        super();
        this.id = id;
        this.type = type;
    }
    
    public byte[] getId() {
        return this.id;
    }
    
    public String getType() {
        return this.type;
    }
       
}
