/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 15.03.2022
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.webauthn;

import java.io.Serializable;

/**
 * <code>
 * {
 *   "requireResidentKey": false,
 *   "userVerification": "discouraged"
 * }
 * </code>
 */
public class AuthenticatorSelection implements Serializable {

    private static final long serialVersionUID = 6080413573364653696L;
    
    private final boolean requireResidentKey;
    private final String userVerification;
    
    /**
     * @param requireResidentKey Whether to us a resident key.
     * @param userVerification Verification constant, see e.g. {@link Constants#USER_VERIFICATION_DISCOURAGED}
     */
    public AuthenticatorSelection(boolean requireResidentKey,
            String userVerification) {
        super();
        this.requireResidentKey = requireResidentKey;
        this.userVerification = userVerification;
    }

    public boolean isRequireResidentKey() {
        return this.requireResidentKey;
    }

    public String getUserVerification() {
        return this.userVerification;
    }
    
}
