/***********************************************************
 * $Id$
 *
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 04.06.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * <pre>
 * {
 *   "url": "https://yubico.com",
 *   "imageUrl": "https://developers.yubico.com/U2F/Images/yubico.png",
 *   "name": "Yubico"
 * }
 * </pre>
 */
public class VendorInfo {

    private final String url;
    private final String imageUrl;
    private final String name;

    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    public VendorInfo(
            @JsonProperty("url") String url,
            @JsonProperty("imageUrl") String imageUrl,
            @JsonProperty("name") String name) {
        super();
        this.url = url;
        this.imageUrl = imageUrl;
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "VendorInfo [url=" + url + ", imageUrl=" + imageUrl + ", name=" + name + "]";
    }

}
