/***********************************************************
 * $Id$
 *
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 09.06.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import java.security.cert.X509Certificate;
import java.util.Arrays;

import org.clazzes.login.jbo.common.Algorithm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * <pre>
 * {
 *   'alg': 'RS256',
 *   'x5c': ['MIIFkzCCB...']
 * }
 * </pre>
 */
public class SafetyNetSignatureHeader {

    private final Algorithm alg;
    private final X509Certificate[] x5c;

    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    public SafetyNetSignatureHeader(
            @JsonProperty("alg") Algorithm alg,
            @JsonProperty("x5c") X509Certificate[] x5c) {
        super();
        this.alg = alg;
        this.x5c = x5c;
    }

    public Algorithm getAlg() {
        return this.alg;
    }

    public X509Certificate[] getX5c() {
        return this.x5c;
    }

    @Override
    public String toString() {
        return "SafetyNetSignatureHeader [alg=" + this.alg + ", x5c=" + Arrays.toString(this.x5c) + "]";
    }

}
