/***********************************************************
 * $Id$
 *
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 11.12.2019
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import org.clazzes.login.jbo.common.Helpers;

/**
 * An authenticator public key credential, see
 * <a href="https://www.w3.org/TR/webauthn/#publickeycredential">the W3C WebAuthn specification</a>
 * for details.
 *
 * This is the toplevel JSON Object returned by the Javascript Token API
 * <code>navigator.credentials.create()</code> or
 * <code>navigator.credentials.get()</code>.
 */
public class PublicKeyCredential {

    private final byte[] id;
    private final AuthenticatorResponse response;

    public PublicKeyCredential(byte[] id, AuthenticatorResponse response) {
        super();
        this.id = id;
        this.response = response;
    }

    public byte[] getId() {
        return this.id;
    }

    public AuthenticatorResponse getResponse() {
        return this.response;
    }

    @Override
    public String toString() {
        return "PublicKeyCredential [id=" + Helpers.formatHex(this.id) +
                ", response=" + this.response + "]";
    }

}
