/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 04.06.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

/**
 * A device selector, only a X.509 extension selector typ is implemented.
 */
public abstract class DeviceSelector {
    
    /**
     * @param aci The attestation certificate info to match.
     * @return Whether this selector matches the given attestation certificate.
     */
    public abstract boolean matches(AttestationCertInfo aci);
    
    /**
     * @return The type of this selector, only <code>x509Extension</code> is impleented.
     */
    public abstract String getType();
}
