/***********************************************************
 * $Id$
 *
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 05.06.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import org.clazzes.login.jbo.common.Helpers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parsed client data, see
 * <a href="https://www.w3.org/TR/webauthn/#dictdef-collectedclientdata">the W3C WebAuthn specification</a>
 * for details.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClientData {

    private final String type;
    private final byte[] challenge;
    private final String origin;
    private final Boolean crossOrigin;

    @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
    public ClientData(
            @JsonProperty("type") String type,
            @JsonProperty("challenge") byte[] challenge,
            @JsonProperty("origin") String origin,
            @JsonProperty("crossOrigin") Boolean crossOrigin) {
        super();
        this.type = type;
        this.challenge = challenge;
        this.origin = origin;
        this.crossOrigin = crossOrigin;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Boolean getCrossOrigin() {
        return this.crossOrigin;
    }

    @Override
    public String toString() {
        return "ClientData [type=" + this.type +
                ", challenge=" + Helpers.formatHex(this.challenge) +
                ", origin=" + this.origin
                + ", crossOrigin=" + this.crossOrigin + "]";
    }

}
