/***********************************************************
 * $Id$
 *
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 24.05.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

import org.clazzes.login.jbo.common.KeyOperation;

/**
 * Helper functions for decoding CBOR structures.
 */
public abstract class CborHelpers {

    public static X509Certificate[] getCertificateChain(Map<String,Object> attStmt, String key) throws Exception {

        @SuppressWarnings("unchecked")
        List<byte[]> x5c = (List<byte[]>)attStmt.get(key);

        X509Certificate[] certificateChain = null;

        if (x5c != null) {

            CertificateFactory cf = CertificateFactory.getInstance("X.509");

            certificateChain = new X509Certificate[x5c.size()];

            for (int i=0;i<x5c.size();++i) {

                byte[] c = x5c.get(i);

                try (ByteArrayInputStream bis = new ByteArrayInputStream(c)) {

                    certificateChain[i] = (X509Certificate)cf.generateCertificate(bis);
                }
            }
        }

        return certificateChain;
    }

    public static final KeyOperation[] getKeyOpsArray(Map<String,Object> pk, String key) {

        @SuppressWarnings("unchecked")
        List<Integer> arr = (List<Integer>)pk.get(key);

        KeyOperation[] ret = null;

        if (arr != null) {

            ret = new KeyOperation[arr.size()];

            for (int i=0;i<arr.size();++i) {

                ret[i] = KeyOperation.getByValue(arr.get(i));
            }
        }

        return ret;
    }

}
