/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 11.12.2019
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import java.io.IOException;

import org.clazzes.login.jbo.u2f.json.CredentialParser;

public abstract class AuthenticatorResponse {

    private final byte[] clientData;
    
    public AuthenticatorResponse(byte[] clientData) {
        this.clientData = clientData;
    }

    public byte[] getClientData() {
        return this.clientData;
    }
    
    public ClientData parseClientData() throws IOException {
        return CredentialParser.parseClientData(this.clientData);
    }
    
    /**
     * @return The response type, which is <code>attestation</code> or <code>assertion</code>.
     */
    abstract String getResponseType();
}
