/***********************************************************
 * $Id$
 *
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 11.12.2019
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

/**
 * An authenticator attestation response, see
 * <a href="https://www.w3.org/TR/webauthn/#authenticatorattestationresponse">the W3C WebAuthn specification</a>
 * for details.
 */
public class AuthenticatorAttestationResponse extends AuthenticatorResponse {

    public static final String RESPONSE_TYPE = null;

    private final byte[] attestationObject;

    public AuthenticatorAttestationResponse(byte[] clientData, byte[] attestationObject) {
        super(clientData);
        this.attestationObject = attestationObject;
    }

    public byte[] getAttestationObject() {
        return this.attestationObject;
    }

    public AttestationObject parseAttestationObject() throws Exception {
        return AttestationObject.parse(this.attestationObject);
    }

    @Override
    String getResponseType() {

        return RESPONSE_TYPE;
    }

}
