/***********************************************************
 * $Id$
 *
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 11.12.2019
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

/**
 * An authenticator assertion response, see
 * <a href="https://www.w3.org/TR/webauthn/#authenticatorassertionresponse">the W3C WebAuthn specification</a>
 * for details.
 */
public class AuthenticatorAssertionResponse extends AuthenticatorResponse {

    public final String RESPONSE_TYPE = "assertion";

    private final byte[] authenticatorData;
    private final byte[] signature;
    private final byte[] userHandle;

    private AuthenticatorData parsedAuthenticatorData;

    public AuthenticatorAssertionResponse(byte[] clientData, byte[] authenticatorData, byte[] signature, byte[] userHandle) {
        super(clientData);
        this.authenticatorData = authenticatorData;
        this.signature = signature;
        this.userHandle = userHandle;
    }

    public byte[] getAuthenticatorData() {
        return this.authenticatorData;
    }

    public AuthenticatorData parseAuthenticatorData() throws Exception {

        if (this.authenticatorData == null) {
            return null;
        }

        if (this.parsedAuthenticatorData == null) {
            this.parsedAuthenticatorData = AuthenticatorData.parse(this.authenticatorData);
        }

        return this.parsedAuthenticatorData;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getUserHandle() {
        return this.userHandle;
    }

    @Override
    String getResponseType() {

        return RESPONSE_TYPE;
    }

}
