/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 24.05.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import java.security.cert.X509Certificate;

import org.clazzes.login.jbo.common.Algorithm;

/**
 * An attestation statement.
 */
public abstract class AttestationStatement {

    /**
     * @return The format of the attestation statement.
     */
    public abstract String getFormat();
    
    public abstract byte[] getSignature();

    public abstract Algorithm getAlgorithm();
    
    public abstract X509Certificate[] getCertificateChain();
    
    
 
}
