/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 12.06.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import java.util.UUID;

/**
 * The result of checking an attestation certificate.
 */
public class AttestationResult {

    private final AttestationCertInfo attestationCertInfo;
    private final UUID registryId;
    private final DeviceInfo deviceInfo;
    private final VendorInfo vendorInfo;
    private final AttestationType attestationType;
    
    public AttestationResult(AttestationCertInfo attestationCertInfo, UUID registryId, DeviceInfo deviceInfo,
            VendorInfo vendorInfo, AttestationType attestationType) {
        super();
        this.attestationCertInfo = attestationCertInfo;
        this.registryId = registryId;
        this.deviceInfo = deviceInfo;
        this.vendorInfo = vendorInfo;
        this.attestationType = attestationType;
    }

    /**
     * @return Detailed information on the attestation certificate and its extensions.
     */
    public AttestationCertInfo getAttestationCertInfo() {
        return this.attestationCertInfo;
    }

    /**
     * @return The UUID of the device registry, against which the certificate has been validated.
     */
    public UUID getRegistryId() {
        return this.registryId;
    }

    /**
     * @return The information on the attested device.
     */
    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    /**
     * @return Information on the device vendor.
     */
    public VendorInfo getVendorInfo() {
        return this.vendorInfo;
    }

    /**
     * @return The type of attestation.
     */
    public AttestationType getAttestationType() {
        return this.attestationType;
    }

    @Override
    public String toString() {
        return "AttestationResult [attestationCertInfo=" + this.attestationCertInfo +
                ", registryId=" + this.registryId +
                ", deviceInfo=" + this.deviceInfo +
                ", vendorInfo=" + this.vendorInfo +
                ", attestationType=" + this.attestationType + "]";
    }

}
