/***********************************************************
 * $Id$
 * 
 * JSON CBOR Login Tools of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 12.06.2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jbo.u2f;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

import org.clazzes.login.jbo.common.Algorithm;

public interface AttestationCertValidator {

    /**
     * @param algorithm An optional algorithm hint, mostly used for RSA keys to specify the padding used for signatures.
     * @param cert The certificate to parse.
     * @return A parsed certificaet information.
     * @throws CertificateEncodingException
     */
    AttestationCertInfo parseCertificate(Algorithm algorithm, X509Certificate cert) throws CertificateEncodingException;

    AttestationResult validateCertificateChain(Algorithm algorithm, X509Certificate[] chain) throws Exception;

    void validateServerCertificateChain(X509Certificate[] chain, String fqdn) throws Exception;

}