/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jaas;

import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.clazzes.login.htpasswd.jaas.HtpasswdAuthServiceFactory;
import org.clazzes.login.htpasswd.jaas.HtpasswdAuthServiceFactoryConfiguration;
import org.clazzes.login.jaas.JaasDomainPasswordLoginService;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasLoginComponent
implements Component {
    private static final Logger log = LoggerFactory.getLogger(JaasLoginComponent.class);
    public static final String CONFIG_PID = "org.clazzes.login.jaas";
    public static final String SERVICE_KEY = "org.clazzes.login.jaas";

    private static final HtpasswdAuthServiceFactoryConfiguration parseConfiguration(ConfigWrapper config) {
        String htpasswdDirString = config.getString("htpasswdDir");
        return new HtpasswdAuthServiceFactoryConfiguration().htpasswdDir(htpasswdDirString == null ? null : Path.of(htpasswdDirString, new String[0])).htpasswdFileContents((Map)Optional.ofNullable(config.getSubTree("htpasswdFileContents")).map(subConfig -> subConfig.getContent().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(null));
    }

    public void start(ServiceContext context) throws Exception {
        ConfigurationEngine ce = (ConfigurationEngine)context.getService(ConfigurationEngine.class).get();
        ServiceRegistry registry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        ComponentManager componentManager = (ComponentManager)context.getService(ComponentManager.class).get();
        HtpasswdAuthServiceFactoryConfiguration initConfig = ce.getPid("org.clazzes.login.jaas").map(c -> JaasLoginComponent.parseConfiguration(c)).orElse(new HtpasswdAuthServiceFactoryConfiguration());
        HtpasswdAuthServiceFactory htpasswdFactory = initConfig.build();
        JaasDomainPasswordLoginService jdps = new JaasDomainPasswordLoginService();
        jdps.setHtpasswdFactory(htpasswdFactory);
        registry.addService("org.clazzes.login.jaas", DomainPasswordLoginService.class, (Object)jdps);
        ce.listen("org.clazzes.login.jaas", config -> {
            JaasLoginComponent jaasLoginComponent = this;
            synchronized (jaasLoginComponent) {
                jdps.setDefaultDomain(config.getString("defaultDomain"));
                htpasswdFactory.setConfig(JaasLoginComponent.parseConfiguration(config));
            }
        });
        componentManager.commit();
    }

    public void stop(ServiceContext context) throws Exception {
        ServiceRegistry registry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        registry.removeService("org.clazzes.login.jaas", DomainPasswordLoginService.class);
    }
}

