/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.jaas;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.clazzes.login.htpasswd.jaas.HtpasswdAuthServiceFactory;
import org.clazzes.login.htpasswd.jaas.HtpasswdGroup;
import org.clazzes.login.htpasswd.jaas.IHtpasswdAuthService;
import org.clazzes.login.jaas.JaasGroup;
import org.clazzes.login.jaas.JaasPrincipal;
import org.clazzes.login.jaas.JaasPrincipalOAuth;
import org.clazzes.util.sec.DomainGroup;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.DomainPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasDomainPasswordLoginService
implements DomainPasswordLoginService {
    private static final Logger log = LoggerFactory.getLogger(JaasDomainPasswordLoginService.class);
    private String defaultDomain;
    private HtpasswdAuthServiceFactory htpasswdFactory;
    private final Map<JaasPrincipal, List<DomainGroup>> userGroups = new ConcurrentHashMap<JaasPrincipal, List<DomainGroup>>();

    public DomainPrincipal tryLogin(String domain, String username, String password) {
        try {
            JaasPrincipal ret;
            Map additionalAttributes;
            IHtpasswdAuthService svc = this.htpasswdFactory.getServiceConfigurable(domain);
            if (!svc.authenticate(username, password.toCharArray())) {
                return null;
            }
            List htpasswdGroups = svc.getUserGroups(username);
            ArrayList<JaasGroup> groups = null;
            if (htpasswdGroups != null) {
                groups = new ArrayList<JaasGroup>(htpasswdGroups.size());
                for (HtpasswdGroup grp : htpasswdGroups) {
                    groups.add(new JaasGroup(grp.getName(), domain));
                }
            }
            if ((additionalAttributes = svc.getUserClaims(username)) == null) {
                ret = new JaasPrincipal(username, domain);
                if (groups != null) {
                    log.info("User [{}] is member of groups {}.", (Object)username, groups);
                    this.userGroups.put(ret, groups);
                }
                log.info("Successful login of user [{}] to domain [{}].", new Object[]{username, domain});
            } else {
                ret = new JaasPrincipalOAuth(username, domain, Collections.unmodifiableMap(additionalAttributes));
                log.info("Successful login of user [{}] to domain [{}] with additional attributes [{}].", new Object[]{username, domain, additionalAttributes});
                if (groups != null) {
                    log.info("User [{}] is member of groups {}.", (Object)username, groups);
                    this.userGroups.put(new JaasPrincipal(username, domain), groups);
                }
            }
            return ret;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception during JAAS authentication", (Throwable)e);
            }
            log.error("Invalid login of user [{}] to domain [{}].", (Object)username, (Object)domain);
            return null;
        }
    }

    public synchronized String getDefaultDomain() {
        return this.defaultDomain;
    }

    public List<String> getDomains() {
        Vector<String> domains = new Vector<String>();
        String defaultDomain = this.getDefaultDomain();
        if (defaultDomain != null && defaultDomain.length() > 0) {
            domains.add(defaultDomain);
        }
        return domains;
    }

    public void changePassword(String domain, String username, String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public void deactivateUser(String domain, String username, String reason) {
        throw new UnsupportedOperationException();
    }

    public List<DomainGroup> getGroups(String domain, String userName) {
        return this.userGroups.get(new JaasPrincipal(userName, domain));
    }

    public List<DomainPrincipal> getGroupMembers(String domain, String groupName) {
        throw new UnsupportedOperationException();
    }

    public int getSupportedFeatures(String domain) {
        return 16;
    }

    public DomainPrincipal searchUser(String domain, String username) {
        throw new UnsupportedOperationException();
    }

    public void sendPassword(String domain, String username) {
        throw new UnsupportedOperationException();
    }

    public synchronized void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public void setHtpasswdFactory(HtpasswdAuthServiceFactory htpasswdFactory) {
        this.htpasswdFactory = htpasswdFactory;
    }
}

