/***********************************************************
 * $Id$
 * 
 * http://www.clazzes.org
 *
 * Created: 02.04.2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jaas;

import java.util.Objects;

import org.clazzes.util.sec.DomainPrincipal;

public class JaasPrincipal implements DomainPrincipal {

    private final String user;
    private final String domain;

    public JaasPrincipal(String user, String domain) {
        super();
        this.user = user;
        this.domain = domain;
    }

    /* (non-Javadoc)
     * @see java.security.Principal#getName()
     */
    @Override
    public String getName() {
        return this.domain + "/" + this.user;
    }

    /**
     * 
     * @return The authenticated JAAS user.
     */
    public String getUserName() {
        return this.user;
    }

    /**
     * @return The JAAS domain against which the user has been authenticated.
     */
    public String getDomain() {
        return this.domain;
    }

    public String getPrettyName() {
        return this.user;
    }

    public String getEMailAddress() {
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.domain,this.user);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        JaasPrincipal other = (JaasPrincipal) obj;
        return Objects.equals(this.domain,other.domain) && Objects.equals(this.user,other.user);
    }

}
