/***********************************************************
 * $Id$
 * 
 * http://www.clazzes.org
 *
 * Created: 02.04.2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.jaas;

import java.util.Map;

import org.clazzes.util.sec.OAuthCredentials;

public class JaasPrincipalOAuth extends JaasPrincipal implements OAuthCredentials {

    private final Map<String,String> additionalAttributes;

    public JaasPrincipalOAuth(String user, String domain, Map<String,String> additionalAttributes) {
        super(user,domain);
        this.additionalAttributes = additionalAttributes;
    }

    public String getPrettyName() {
        
        String ret = this.getAdditionalAttribute("name");

        return ret == null ? super.getPrettyName() : ret;
    }

    public String getEMailAddress() {
        return this.getAdditionalAttribute("email");
    }

    @Override
    public String getBearerToken() {
        
        return null;
    }

    @Override
    public Map<String, String> getAdditionalAttributes() {
        
        return this.additionalAttributes;
    }

    @Override
    public String getAdditionalAttribute(String key) {
        
        if (this.additionalAttributes == null) {
            return null;
        }

        return this.additionalAttributes.get(key);
    }

}
