/**
 * $Id$
 *
 * Enterprise Service Management
 * (c) 2019 ITEG IT-Engineers GmbH https://www.iteg.at
 */
package org.clazzes.login.jaas;

import java.util.Objects;

import org.clazzes.util.sec.DomainGroup;

/**
 * A group implementation for returning JAAS group memberships.
 */
public class JaasGroup implements DomainGroup {

    private final String group;
    private final String domain;

    public JaasGroup(String group, String domain) {
        super();
        this.group = group;
        this.domain = domain;
    }

    @Override
    public String getName() {
        return this.domain + "/" + this.group;
    }

    @Override
    public String getGroupName() {
        
        return this.group;
    }

    @Override
    public String getDomain() {
        
        return this.domain;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.domain,this.group);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        JaasGroup other = (JaasGroup)obj;
        return Objects.equals(this.domain,other.domain) && Objects.equals(this.group,other.group);
    }

    @Override
    public String toString() {
        return "JaasGroup[" + this.getName() + "]";
    }

}
