/***********************************************************
 * $Id$
 *
 * http://www.clazzes.org
 *
 * Created: 02.04.2011
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.jaas;

import java.util.Dictionary;

import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService implements ManagedService {

	private static final Logger log = LoggerFactory.getLogger(ConfigurationService.class);

	private static final String DEFAULT_DEFAULT_DOMAIN = "osgi";

	private String defaultDomain;


	public ConfigurationService() {
		this.defaultDomain = DEFAULT_DEFAULT_DOMAIN;
	}


	@SuppressWarnings("rawtypes")
	@Override
	public void updated(Dictionary properties) throws ConfigurationException {

		Object s = properties == null ? null : properties.get("defaultDomain");
		if (s != null) {
			this.defaultDomain = s.toString();
			if (log.isDebugEnabled())
				log.debug("Setting default domain to [{}].",this.defaultDomain);
		}
		else {
			this.defaultDomain = DEFAULT_DEFAULT_DOMAIN;
			if (log.isDebugEnabled())
				log.debug("Setting default domain to default [{}].",this.defaultDomain);
		}

	}


	public String getDefaultDomain() {
		return defaultDomain;
	}


	public void setDefaultDomain(String defaultDomain) {
		this.defaultDomain = defaultDomain;
	}


}
