/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.clazzes.fancymail.server.api.EMailAddressDTO;
import org.clazzes.fancymail.server.api.EMailDTO;
import org.clazzes.fancymail.server.api.EMailSenderDTO;
import org.clazzes.fancymail.server.api.FancyMailServerSMSService;
import org.clazzes.fancymail.server.api.FancyMailServerService;
import org.clazzes.fancymail.server.api.SMSDTO;
import org.clazzes.fancymail.server.api.SMSDestinationDTO;
import org.clazzes.fancymail.server.api.SMSSenderDTO;
import org.clazzes.login.adapter.http.MFAService;
import org.clazzes.login.adapter.http.i18n.HttpLoginMessages;
import org.clazzes.util.aop.i18n.Messages;
import org.clazzes.util.sec.DomainPrincipal;
import org.clazzes.util.sec.HashTools;
import org.clazzes.util.sec.MFAPrincipal;
import org.clazzes.util.sec.TokenOtpChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFAServiceImpl
implements MFAService {
    private static final Logger log = LoggerFactory.getLogger(MFAServiceImpl.class);
    private FancyMailServerSMSService smsService;
    private String smsSender;
    private FancyMailServerService mailService;
    private String mailSender;
    private TokenOtpChecker tokenOtpChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenOtpCheckerBound(TokenOtpChecker tokenOtpChecker) {
        log.info("Service of type TokenOtpChecker became available, token OTP checks are now activated.");
        MFAServiceImpl mFAServiceImpl = this;
        synchronized (mFAServiceImpl) {
            this.tokenOtpChecker = tokenOtpChecker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenOtpCheckerUnbound(TokenOtpChecker tokenOtpChecker) {
        log.info("Service of type TokenOtpChecker disappeared, token OTP checks are now disabled.");
        MFAServiceImpl mFAServiceImpl = this;
        synchronized (mFAServiceImpl) {
            this.tokenOtpChecker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTokenOtp(String otp, String[] knownIds) {
        TokenOtpChecker checker;
        MFAServiceImpl mFAServiceImpl = this;
        synchronized (mFAServiceImpl) {
            checker = this.tokenOtpChecker;
        }
        try {
            return checker.checkOTP(otp, knownIds);
        }
        catch (IOException e) {
            log.error("Checking a token OTP failed", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mailServiceBound(FancyMailServerService mailService) {
        if (this.mailSender != null && this.mailSender.length() > 0) {
            log.info("Service of type FancyMailServerService became available, mail sending is now activated for sender [{}].", (Object)this.mailSender);
            EMailSenderDTO sender = mailService.getSenderAddress(this.mailSender);
            if (sender == null) {
                log.info("Creating new mail sender for address [{}]", (Object)this.mailSender);
                sender = new EMailSenderDTO();
                sender.setPersonalName("clazzes.org Login Service");
                sender.setAddress(this.mailSender);
                mailService.insertSender(sender);
            }
        } else {
            log.info("Service of type FancyMailServerService became available, but no mail sender is configured, e-mail sending will not be activated.");
            return;
        }
        MFAServiceImpl mFAServiceImpl = this;
        synchronized (mFAServiceImpl) {
            this.mailService = mailService;
        }
    }

    public synchronized void mailServiceUnbound(FancyMailServerService smsService) {
        log.info("Service of type FancyMailServerService disappeared, mail sending is now disabled.");
        this.mailService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void smsServiceBound(FancyMailServerSMSService smsService) {
        if (this.smsSender != null && this.smsSender.length() > 0) {
            log.info("Service of type FancyMailServerSMSService became available, SMS sending is now activated for sender [{}].", (Object)this.smsSender);
            SMSSenderDTO sender = smsService.getSenderDto(this.smsSender);
            if (sender == null) {
                log.info("Creating new SMS sender for source number [{}]", (Object)this.smsSender);
                sender = new SMSSenderDTO();
                sender.setPersonalName("msmasml");
                sender.setSourceNumber(this.smsSender);
                smsService.insertSender(sender);
            }
        } else {
            log.info("Service of type FancyMailServerSMSService became available, but no SMS sender is configured, SMS sending will not be activated.");
            return;
        }
        MFAServiceImpl mFAServiceImpl = this;
        synchronized (mFAServiceImpl) {
            this.smsService = smsService;
        }
    }

    public synchronized void smsServiceUnbound(FancyMailServerSMSService smsService) {
        log.info("Service of type FancyMailServerSMSService disappeared, SMS sending is now disabled.");
        this.smsService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateEmphemeralOtp(Locale locale, String host, DomainPrincipal principal, MFAPrincipal mfaPrincipal) {
        FancyMailServerService mailService;
        FancyMailServerSMSService smsService;
        Messages i18n = HttpLoginMessages.getMessages(locale);
        MFAServiceImpl mFAServiceImpl = this;
        synchronized (mFAServiceImpl) {
            smsService = this.smsService;
            mailService = this.mailService;
        }
        if (smsService == null && mailService == null) {
            log.warn("No service of type FancyMailServerSMSService FancyMailServerService is available, ephemeral OTPs are unavailable.");
            return null;
        }
        String otp = HashTools.randomSaltSms((int)8);
        String mobile = mfaPrincipal.getMobileNumber();
        String email = principal.getEMailAddress();
        if (smsService != null && mobile != null) {
            SMSDTO sms = new SMSDTO();
            ArrayList<SMSDestinationDTO> destinations = new ArrayList<SMSDestinationDTO>();
            SMSDestinationDTO dest = new SMSDestinationDTO();
            dest.setDestNumber(mobile);
            dest.setPersonalName(principal.getPrettyName());
            destinations.add(dest);
            sms.setSender(this.smsSender);
            sms.setDestinations(destinations);
            sms.setText(String.format(locale, i18n.getString("emphemeralOtpSms.body"), principal.getName(), host, otp));
            smsService.queueSMS(sms);
        } else if (mailService != null && email != null) {
            EMailDTO mail = new EMailDTO();
            EMailAddressDTO dest = new EMailAddressDTO();
            dest.setAddress(email);
            dest.setPersonalName(principal.getPrettyName());
            ArrayList<EMailAddressDTO> to = new ArrayList<EMailAddressDTO>();
            to.add(dest);
            mail.setSender(this.mailSender);
            mail.setTo(to);
            mail.setSubject(String.format(locale, i18n.getString("emphemeralOtpSms.subject"), principal.getName(), host));
            mail.setBody(String.format(locale, i18n.getString("emphemeralOtpSms.body"), principal.getName(), host, otp));
            mailService.queueMail(mail);
        } else {
            if (smsService != null) {
                if (mailService != null) {
                    log.warn("No mobile number or email address for user [{}] to deliver OTP to.", (Object)principal.getName());
                } else {
                    log.warn("No mobile number for user [{}] to deliver OTP to.", (Object)principal.getName());
                }
            } else {
                log.warn("No email address for user [{}] to deliver OTP to.", (Object)principal.getName());
            }
            return null;
        }
        return otp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mayReceiveEphemeralOtp(DomainPrincipal principal, MFAPrincipal mfaPrincipal) {
        FancyMailServerService mailService;
        FancyMailServerSMSService smsService;
        MFAServiceImpl mFAServiceImpl = this;
        synchronized (mFAServiceImpl) {
            smsService = this.smsService;
            mailService = this.mailService;
        }
        String mobile = mfaPrincipal.getMobileNumber();
        if (smsService != null && mobile != null) {
            return true;
        }
        String email = principal.getEMailAddress();
        return mailService != null && email != null;
    }

    public void setSmsSender(String smsSender) {
        this.smsSender = smsSender;
    }

    public void setMailSender(String mailSender) {
        this.mailSender = mailSender;
    }
}

