/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import jakarta.servlet.Servlet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.clazzes.fancymail.server.api.FancyMailServerSMSService;
import org.clazzes.fancymail.server.api.FancyMailServerService;
import org.clazzes.login.adapter.http.DomainHttpLoginService;
import org.clazzes.login.adapter.http.DomainLoginServlet;
import org.clazzes.login.adapter.http.LoginInfoCache;
import org.clazzes.login.adapter.http.MFAService;
import org.clazzes.login.adapter.http.MFAServiceImpl;
import org.clazzes.login.adapter.http.PageTokenServiceImpl;
import org.clazzes.login.adapter.http.SameSitePolicy;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ComponentSupport;
import org.clazzes.svc.api.ConfigWrapper;
import org.clazzes.svc.api.ServiceProperties;
import org.clazzes.svc.api.ServiceProperty;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.http.AdditionalHeader;
import org.clazzes.util.http.ResourceServlet;
import org.clazzes.util.http.sec.HttpLoginService;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.TokenOtpChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServiceListener
extends ComponentSupport
implements Consumer<ConfigWrapper> {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceListener.class);
    public static final int DEFAULT_MAX_AGE_SECONDS = 3600;
    public static final int DEFAULT_FAILURE_TIMEOUT = 500;
    public static final int DEFAULT_SESSION_TIMEOUT = 180;
    public static final int DEFAULT_MAX_PAGE_TOKENS = 5000;
    public static final String DEFAULT_SESSION_COOKIE = "LOGIN_SESSION_ID";
    public static final boolean DEFAULT_SECURE_COOKIE = true;
    public static final SameSitePolicy DEFAULT_SAME_SITE_POLICY = SameSitePolicy.Strict;
    public static final boolean DEFAULT_DO_TIMEZONE_CHECK = false;
    public static final int DEFAULT_EPHEMERAL_OTP_SECONDS = 300;
    public static final boolean DEFAULT_DO_GROUPS_CHECK = false;
    public static final boolean DEFAULT_LOGOUT_ALL_MECHANISMS = false;
    private final ServiceRegistry serviceRegistry;
    private final ComponentManager componentManager;
    private LoginInfoCache loginInfoCache;
    private PageTokenServiceImpl pageTokenService;
    private MFAService mfaService;
    private int sessionTimeout = 180;
    private long failureTimeout;
    private String sessionCookie;
    private boolean secureCookie;
    private SameSitePolicy sameSitePolicy;
    private boolean doTimeZoneDetection;
    private boolean doGroupsCheck;
    private boolean logoutAllMechanisms = true;
    private int ephemeralOtpSeconds;
    private Map<String, ServiceInfo> registrations;

    private static final String makeServletAlias(String mechanism) {
        return "/http-login/" + mechanism + "/login";
    }

    private final void deregisterLoginServlet(ServiceInfo serviceInfo) {
        if (serviceInfo.getServletAlias() != null) {
            log.info("Deregistering login servlet [{}]", (Object)serviceInfo.getServletAlias());
            this.serviceRegistry.removeService(serviceInfo.getServletAlias(), Servlet.class);
            serviceInfo.setServletAlias(null);
        }
    }

    private final void registerLoginServlet(String mechanism, ServiceInfo serviceInfo) {
        DomainLoginServlet loginServlet = new DomainLoginServlet();
        loginServlet.setLoginService(serviceInfo.getDomainHttpLoginService());
        loginServlet.setPageTokenService(this.pageTokenService);
        loginServlet.setI18nPrefix(serviceInfo.getI18nPrefix());
        String alias = LoginServiceListener.makeServletAlias(mechanism);
        log.info("Registering login servlet [{}]", (Object)alias);
        serviceInfo.setServletAlias(alias);
        this.serviceRegistry.addService(alias, Servlet.class, (Object)loginServlet);
    }

    public LoginServiceListener(ServiceRegistry serviceRegistry, ComponentManager componentManager) {
        this.serviceRegistry = serviceRegistry;
        this.componentManager = componentManager;
    }

    public synchronized void serviceBound(String mechanism, DomainPasswordLoginService domainPasswordLoginService) {
        DomainHttpLoginService loginService = new DomainHttpLoginService();
        loginService.setLoginInfoCache(this.loginInfoCache);
        loginService.setMfaService(this.mfaService);
        loginService.setLoginMechanism(mechanism);
        loginService.setDomainPasswordLoginService(domainPasswordLoginService);
        loginService.setFailureTimeout(this.failureTimeout);
        loginService.setSessionTimeout(this.sessionTimeout);
        loginService.setDoTimeZoneDetection(this.doTimeZoneDetection);
        loginService.setDoGroupsCheck(this.doGroupsCheck);
        loginService.setLogoutAllMechanisms(this.logoutAllMechanisms);
        loginService.setSecureCookie(this.secureCookie);
        loginService.setSameSitePolicy(this.sameSitePolicy);
        loginService.setSessionCookie(this.sessionCookie);
        loginService.setEphemeralOtpSeconds(this.ephemeralOtpSeconds);
        log.info("Registering HttpLoginService for mechanism [{}]", (Object)mechanism);
        this.serviceRegistry.addService(mechanism, HttpLoginService.class, (Object)loginService);
        ServiceInfo info = new ServiceInfo(loginService, domainPasswordLoginService.getClass().getAnnotation(ServiceProperties.class));
        if (this.registrations == null) {
            this.registrations = new HashMap<String, ServiceInfo>();
        }
        this.registrations.put(mechanism, info);
        this.registerLoginServlet(mechanism, info);
    }

    public synchronized void serviceUnbound(String mechanism, DomainPasswordLoginService domainPasswordLoginService) {
        ServiceInfo info = this.registrations.remove(mechanism);
        if (info == null) {
            log.warn("DomainPasswordLoginService for mechanism [{}] became unavailable wihtout prior registration.", (Object)mechanism);
            return;
        }
        log.info("Unregistering HttpLoginService for mechanism [{}]", (Object)mechanism);
        this.serviceRegistry.removeService(mechanism, HttpLoginService.class);
        this.deregisterLoginServlet(info);
        if (this.registrations.isEmpty()) {
            this.registrations = null;
        }
    }

    public void stop() {
        this.closeAllListeners((closeable, e) -> log.warn("Error closing http-login-adpater listener [{}]", closeable, e));
        this.removeAllServices(this.serviceRegistry);
    }

    @Override
    public synchronized void accept(ConfigWrapper config) {
        if (log.isDebugEnabled()) {
            log.debug("updated called: properties=[{}]", (Object)config);
        }
        this.stop();
        this.pageTokenService.accept(config);
        this.sessionTimeout = config.getInt("sessionTimeout", 180);
        this.failureTimeout = config.getInt("failureTimeout", 500);
        this.doTimeZoneDetection = config.getBoolean("doTimeZoneDetection", false);
        this.doGroupsCheck = config.getBoolean("doGroupsCheck", false);
        this.sessionCookie = config.getString("sessionCookie", DEFAULT_SESSION_COOKIE);
        char c = this.sessionCookie.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            throw new IllegalArgumentException("session\u0106ookie does not start with an ASCII letter.");
        }
        for (int i = 1; i < this.sessionCookie.length(); ++i) {
            c = this.sessionCookie.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue;
            throw new IllegalArgumentException("session\u0106ookie contains chracters other than ASCII numbers, letters or underscores.");
        }
        this.secureCookie = config.getBoolean("secureCookie", true);
        this.sameSitePolicy = (SameSitePolicy)config.getEnum(SameSitePolicy.class, "sameSitePolicy", (Enum)DEFAULT_SAME_SITE_POLICY);
        this.logoutAllMechanisms = config.getBoolean("logoutAllMechanisms", false);
        this.ephemeralOtpSeconds = config.getInt("ephemeralOtpSeconds", 300);
        String mailSender = config.getString("mailSender");
        String smsSender = config.getString("smsSender");
        log.info("setting up MFA Service with mail sender [{}] and SMS sender [{}]", (Object)mailSender, (Object)smsSender);
        MFAServiceImpl mfai = new MFAServiceImpl();
        mfai.setMailSender(mailSender);
        mfai.setSmsSender(smsSender);
        this.addListener(this.serviceRegistry.listen("fancymail-server", FancyMailServerService.class, svc -> mfai.mailServiceBound((FancyMailServerService)svc), svc -> mfai.mailServiceUnbound((FancyMailServerService)svc)));
        this.addListener(this.serviceRegistry.listen("fancymail-server", FancyMailServerSMSService.class, svc -> mfai.smsServiceBound((FancyMailServerSMSService)svc), svc -> mfai.smsServiceUnbound((FancyMailServerSMSService)svc)));
        this.addListener(this.serviceRegistry.listen("yubikey", TokenOtpChecker.class, svc -> mfai.tokenOtpCheckerBound((TokenOtpChecker)svc), svc -> mfai.tokenOtpCheckerUnbound((TokenOtpChecker)svc)));
        this.mfaService = mfai;
        this.addListener(this.serviceRegistry.listenAll(DomainPasswordLoginService.class, (key, svc) -> this.serviceBound((String)key, (DomainPasswordLoginService)svc), (key, svc) -> this.serviceUnbound((String)key, (DomainPasswordLoginService)svc)));
        ResourceServlet resourceServlet = new ResourceServlet();
        resourceServlet.setMaxAgeSeconds(3600);
        resourceServlet.addAdditionalHeader(new AdditionalHeader("X-Frame-Options", "SAMEORIGIN", null, Pattern.compile("text/html")));
        resourceServlet.setResourceModule(LoginServiceListener.class.getModule());
        resourceServlet.setResourcePath("/META-INF/webapp/http-login");
        resourceServlet.addExcludeMimeType("image/png");
        resourceServlet.addExcludeMimeType("image/gif");
        resourceServlet.addExcludeMimeType("image/jpeg");
        resourceServlet.addExcludeMimeType("image/tiff");
        this.addService(this.serviceRegistry, "/http-login/*", Servlet.class, resourceServlet);
        this.componentManager.commit();
    }

    public void setLoginInfoCache(LoginInfoCache loginInfoCache) {
        this.loginInfoCache = loginInfoCache;
    }

    public void setPageTokenService(PageTokenServiceImpl pageTokenService) {
        this.pageTokenService = pageTokenService;
    }

    public void setMfaService(MFAService mfaService) {
        this.mfaService = mfaService;
    }

    private static final class ServiceInfo {
        private final DomainHttpLoginService domainHttpLoginService;
        private final String i18nPrefix;
        private String servletAlias;

        public ServiceInfo(DomainHttpLoginService domainHttpLoginService, ServiceProperties props) {
            this.domainHttpLoginService = domainHttpLoginService;
            String i18nPfx = null;
            if (props != null) {
                for (ServiceProperty prop : props.value()) {
                    if (!"login.i18n.prefix".equals(prop.key())) continue;
                    i18nPfx = prop.value();
                    break;
                }
            }
            this.i18nPrefix = i18nPfx;
        }

        public DomainHttpLoginService getDomainHttpLoginService() {
            return this.domainHttpLoginService;
        }

        public String getI18nPrefix() {
            return this.i18nPrefix;
        }

        public String getServletAlias() {
            return this.servletAlias;
        }

        public void setServletAlias(String servletAlias) {
            this.servletAlias = servletAlias;
        }
    }
}

