/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.clazzes.login.adapter.http.LoginInfo;
import org.clazzes.login.adapter.http.LoginInfoCache;
import org.clazzes.login.adapter.http.MFAService;
import org.clazzes.login.adapter.http.MFAState;
import org.clazzes.login.adapter.http.SameSitePolicy;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.http.LocaleHelper;
import org.clazzes.util.http.RequestHelper;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.http.sec.HttpLoginService;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.DomainPrincipal;
import org.clazzes.util.sec.MFAPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainHttpLoginService
implements HttpLoginService {
    private static final Logger log = LoggerFactory.getLogger(DomainHttpLoginService.class);
    private DomainPasswordLoginService domainPasswordLoginService;
    private MFAService mfaService;
    private String loginMechanism;
    private int sessionTimeout;
    private long failureTimeout;
    private boolean doTimeZoneDetection;
    private String sessionCookie;
    private boolean secureCookie;
    private SameSitePolicy sameSitePolicy;
    private boolean logoutAllMechanisms = true;
    private boolean doGroupsCheck;
    private int ephemeralOtpSeconds;
    private String loginUrl;
    private LoginInfoCache loginInfoCache;

    public String getLoginUrl() {
        return this.loginUrl;
    }

    private final String parseCookie(HttpServletRequest req) {
        String[] allCookies;
        String allCookies_s = req.getHeader("Cookie");
        if (allCookies_s == null) {
            return null;
        }
        for (String s : allCookies = allCookies_s.split("\\s*;\\s*")) {
            String[] kv = s.split("\\s*=\\s*", 2);
            if (kv.length != 2 || !kv[0].equals(this.sessionCookie)) continue;
            return kv[1];
        }
        return null;
    }

    private LoginInfo getLoginInfoFromCookie(HttpServletRequest req) {
        String sessionId = this.parseCookie(req);
        if (sessionId == null) {
            return null;
        }
        return this.loginInfoCache.getLoginInfo(sessionId);
    }

    public Principal checkLogin(HttpServletRequest req) {
        LoginInfo loginInfo = this.getLoginInfoFromCookie(req);
        if (loginInfo == null) {
            return null;
        }
        MFAState state = loginInfo.getMFAState(this.loginMechanism);
        if (state == null || state.getState() != MFAState.State.AUTHENTICATED) {
            return null;
        }
        DomainPrincipal ret = state.getPrincipal();
        if (ret != null) {
            loginInfo.touch((long)this.sessionTimeout * 60000L);
        }
        return ret;
    }

    public List<? extends Principal> checkLoginGroups(HttpServletRequest req) {
        LoginInfo loginInfo = this.getLoginInfoFromCookie(req);
        if (loginInfo == null) {
            return null;
        }
        MFAState state = loginInfo.getMFAState(this.loginMechanism);
        if (state == null || state.getState() != MFAState.State.AUTHENTICATED) {
            return null;
        }
        return state.getGroups();
    }

    public MFAState checkMFALogin(HttpServletRequest req) {
        LoginInfo loginInfo = this.getLoginInfoFromCookie(req);
        if (loginInfo == null) {
            return null;
        }
        MFAState state = loginInfo.getMFAState(this.loginMechanism);
        if (state != null) {
            loginInfo.touch((long)this.sessionTimeout * 60000L);
        }
        return state;
    }

    public Locale getLocale(HttpServletRequest req) {
        String loc_s;
        Locale loc = null;
        LoginInfo loginInfo = this.getLoginInfoFromCookie(req);
        if (loginInfo != null) {
            loc = loginInfo.getLocale();
        }
        if ((loc_s = UrlHelper.getStringParameter((String)req.getQueryString(), (String)"locale")) != null) {
            loc = LocaleHelper.localeFromXsLanguage((String)loc_s);
        }
        if (loc == null) {
            loc = req.getLocale();
        }
        if (loc == null) {
            loc = Locale.getDefault();
        }
        return loc;
    }

    public TimeZone getTimeZone(HttpServletRequest req) {
        LoginInfo loginInfo = this.getLoginInfoFromCookie(req);
        TimeZone tz = null;
        if (loginInfo != null) {
            tz = loginInfo.getTimeZone();
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        return tz;
    }

    public boolean checkPermission(HttpServletRequest req, String context) {
        return context.equals(this.loginUrl);
    }

    public void logout(HttpServletRequest req) {
        this.logoutCheckForOAuth(req);
    }

    public boolean logoutCheckForOAuth(HttpServletRequest req) {
        String sessionId = this.parseCookie(req);
        if (sessionId == null) {
            return false;
        }
        if (this.logoutAllMechanisms) {
            LoginInfo loginInfo = this.loginInfoCache.removeLoginInfo(sessionId);
            if (loginInfo != null) {
                log.info("Logout of [{}] from all mechanisms.", (Object)loginInfo.getPrincipalsInfo());
                return loginInfo.isFromOAuth();
            }
            return false;
        }
        LoginInfo loginInfo = this.loginInfoCache.getLoginInfo(sessionId);
        if (loginInfo != null) {
            log.info("Logout of [{}] from mechanism [{}].", (Object)loginInfo.getPrincipalsInfo(), (Object)this.loginMechanism);
            MFAState state = loginInfo.removeMFAState(this.loginMechanism);
            if (state == null) {
                log.info("User [{}] is areay logged out from mechanism [{}].", (Object)loginInfo.getPrincipalsInfo(), (Object)this.loginMechanism);
            }
            return loginInfo.isFromOAuth();
        }
        return false;
    }

    public String getDefaultDomain() {
        return this.domainPasswordLoginService.getDefaultDomain();
    }

    public List<String> getDomains() {
        return this.domainPasswordLoginService.getDomains();
    }

    public MFAState checkTokenOtp(HttpServletRequest req, HttpServletResponse resp, String otp, Locale locale) {
        LoginInfo loginInfo = this.getLoginInfoFromCookie(req);
        if (loginInfo == null) {
            return null;
        }
        MFAState state = loginInfo.getMFAState(this.loginMechanism);
        if (state == null) {
            return null;
        }
        MFAPrincipal mfaPrincipal = state.getMfaPrincipal();
        if (mfaPrincipal == null) {
            return state;
        }
        log.info("Checking token OTP for user [{}]...", (Object)state.getPrincipal().getName());
        boolean ok = this.getMfaService().checkTokenOtp(otp, mfaPrincipal.getKnownTokenIds());
        log.info("Check of token OTP for user [{}] returned [{}].", (Object)state.getPrincipal().getName(), (Object)ok);
        if (ok) {
            MFAState ret = new MFAState(state);
            loginInfo.addMFAState(this.loginMechanism, ret);
            return ret;
        }
        return state;
    }

    public MFAState checkEphemeralOtp(HttpServletRequest req, HttpServletResponse resp, String otp, Locale locale) {
        LoginInfo loginInfo = this.getLoginInfoFromCookie(req);
        if (loginInfo == null) {
            return null;
        }
        MFAState state = loginInfo.getMFAState(this.loginMechanism);
        if (state == null) {
            return null;
        }
        MFAPrincipal mfaPrincipal = state.getMfaPrincipal();
        if (mfaPrincipal == null) {
            return state;
        }
        if (System.currentTimeMillis() > state.getEphemeralOtpExpiry()) {
            log.error("Ephemeral OTP for user [{}] has already expired.", (Object)state.getPrincipal().getName());
            return null;
        }
        log.info("Checking ephemeral OTP for user [{}]...", (Object)state.getPrincipal().getName());
        boolean ok = otp != null && otp.equals(state.getEphemeralOtp());
        log.info("Check of ephemeral OTP for user [{}] returned [{}].", (Object)state.getPrincipal().getName(), (Object)ok);
        if (ok) {
            MFAState ret = new MFAState(state);
            loginInfo.addMFAState(this.loginMechanism, ret);
            return ret;
        }
        return state;
    }

    public MFAState generateSmsToken(HttpServletRequest req, Locale locale) {
        String host;
        LoginInfo loginInfo = this.getLoginInfoFromCookie(req);
        if (loginInfo == null) {
            return null;
        }
        MFAState state = loginInfo.getMFAState(this.loginMechanism);
        if (state == null) {
            return null;
        }
        DomainPrincipal principal = state.getPrincipal();
        List<? extends Principal> groups = state.getGroups();
        MFAPrincipal mfaPrincipal = state.getMfaPrincipal();
        if (mfaPrincipal == null) {
            return state;
        }
        try {
            URI uri = RequestHelper.getOriginalRequestUri((HttpServletRequest)req);
            host = uri.getHost();
            log.info("Generating OTP for user [{}] for original URI [{}].", (Object)principal.getName(), (Object)uri);
        }
        catch (Exception e) {
            log.error("Unable to determine original request URI, generating OTP for user [" + principal.getName() + "] unknown host.", (Throwable)e);
            host = "<unkown>";
        }
        String otp = this.getMfaService().generateEmphemeralOtp(locale, host, principal, mfaPrincipal);
        MFAState ret = new MFAState(principal, groups, otp, System.currentTimeMillis() + (long)this.ephemeralOtpSeconds * 1000L);
        loginInfo.addMFAState(this.loginMechanism, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MFAState tryLogin(HttpServletRequest req, HttpServletResponse resp, String domain, String user, String password, Locale locale, TimeZone tz) {
        DomainPrincipal principal;
        if (locale != null) {
            ThreadLocalManager.bindLoginLocale((Locale)locale);
        }
        List groups = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Checking password of user [{}] with domain [{}]...", (Object)user, (Object)domain);
            }
            if ((principal = this.domainPasswordLoginService.tryLogin(domain, user, password)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Successfully logged on as [{}].", (Object)principal.getName());
                }
                if (this.isDoGroupsCheck() && (this.domainPasswordLoginService.getSupportedFeatures(domain) & 0x10) != 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Checking groups of user [{}] with domain [{}]...", (Object)user, (Object)domain);
                    }
                    groups = this.domainPasswordLoginService.getGroups(domain, user);
                    if (log.isDebugEnabled()) {
                        log.debug("Successfully checked groups as [{}].", (Object)groups);
                    }
                }
            }
        }
        finally {
            if (locale != null) {
                ThreadLocalManager.unbindLoginLocale();
            }
        }
        if (principal == null) {
            log.error("Invalid initial login of user [{}] to domain [{}].", (Object)user, (Object)domain);
            return null;
        }
        String sessionId = this.parseCookie(req);
        MFAState mfaState = new MFAState(principal, groups);
        MFAPrincipal mfaPrincipal = mfaState.getMfaPrincipal();
        if (mfaPrincipal != null && mfaPrincipal.getKnownTokenIds() == null) {
            String host;
            try {
                URI uri = RequestHelper.getOriginalRequestUri((HttpServletRequest)req);
                host = uri.getHost();
                log.info("Generating OTP for user [{}] for original URI [{}].", (Object)principal.getName(), (Object)uri);
            }
            catch (Exception e) {
                log.error("Unable to determine original request URI, generating OTP for user [" + principal.getName() + "] unknown host.", (Throwable)e);
                host = "<unkown>";
            }
            String otp = this.getMfaService().generateEmphemeralOtp(locale, host, principal, mfaPrincipal);
            mfaState = new MFAState(principal, groups, otp, System.currentTimeMillis() + (long)this.ephemeralOtpSeconds * 1000L);
        }
        boolean fromOAuth = "true".equals(req.getParameter("oauth"));
        LoginInfo loginInfo = this.loginInfoCache.createLoginInfo(sessionId, this.loginMechanism, mfaState, locale, tz, (long)this.sessionTimeout * 60000L, fromOAuth);
        log.info("Successful login of user [{}] with locale [{}] and timezone [{}].", new Object[]{principal.getName(), locale, tz == null ? null : tz.getID()});
        if (groups != null) {
            log.info("Login groups of user [{}] are [{}].", (Object)principal.getName(), (Object)groups);
        }
        if (!loginInfo.getSessionId().equals(sessionId)) {
            StringBuffer cookie = new StringBuffer();
            cookie.append(this.sessionCookie);
            cookie.append("=");
            cookie.append(loginInfo.getSessionId());
            cookie.append("; Path=/; ");
            if (this.sameSitePolicy != null) {
                cookie.append("SameSite=");
                cookie.append((Object)this.sameSitePolicy);
                cookie.append("; ");
            }
            if (this.secureCookie) {
                cookie.append("Secure; ");
            }
            cookie.append("HttpOnly");
            resp.setHeader("Set-Cookie", cookie.toString());
        }
        return mfaState;
    }

    public boolean mayReveiceEphemeralOtp(MFAState state) {
        return this.getMfaService().mayReceiveEphemeralOtp(state.getPrincipal(), state.getMfaPrincipal());
    }

    public DomainPasswordLoginService getDomainPasswordLoginService() {
        return this.domainPasswordLoginService;
    }

    public void setDomainPasswordLoginService(DomainPasswordLoginService domainPasswordLoginService) {
        this.domainPasswordLoginService = domainPasswordLoginService;
    }

    public LoginInfoCache getLoginInfoCache() {
        return this.loginInfoCache;
    }

    public void setLoginInfoCache(LoginInfoCache loginInfoCache) {
        this.loginInfoCache = loginInfoCache;
    }

    public synchronized void setMfaService(MFAService mfaService) {
        this.mfaService = mfaService;
    }

    public synchronized MFAService getMfaService() {
        return this.mfaService;
    }

    public String getLoginMechanism() {
        return this.loginMechanism;
    }

    public void setLoginMechanism(String loginMechanism) {
        this.loginMechanism = loginMechanism;
        this.loginUrl = "/http-login/" + this.loginMechanism + "/login";
    }

    public synchronized boolean isLogoutAllMechanisms() {
        return this.logoutAllMechanisms;
    }

    public synchronized void setLogoutAllMechanisms(boolean logoutAllMechanisms) {
        this.logoutAllMechanisms = logoutAllMechanisms;
    }

    public static Logger getLog() {
        return log;
    }

    public synchronized void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public synchronized int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public synchronized long getFailureTimeout() {
        return this.failureTimeout;
    }

    public synchronized void setFailureTimeout(long failureTimeout) {
        this.failureTimeout = failureTimeout;
    }

    public synchronized boolean isDoTimeZoneDetection() {
        return this.doTimeZoneDetection;
    }

    public synchronized void setDoTimeZoneDetection(boolean doTimeZoneDetection) {
        this.doTimeZoneDetection = doTimeZoneDetection;
    }

    public synchronized boolean isDoGroupsCheck() {
        return this.doGroupsCheck;
    }

    public synchronized void setDoGroupsCheck(boolean doGroupsCheck) {
        this.doGroupsCheck = doGroupsCheck;
    }

    public synchronized void setSessionCookie(String sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public synchronized void setSecureCookie(boolean secureCookie) {
        this.secureCookie = secureCookie;
    }

    public synchronized void setSameSitePolicy(SameSitePolicy sameSitePolicy) {
        this.sameSitePolicy = sameSitePolicy;
    }

    public synchronized void setEphemeralOtpSeconds(int ephemeralOtpSeconds) {
        this.ephemeralOtpSeconds = ephemeralOtpSeconds;
    }
}

