/***********************************************************
 * $Id$
 * 
 * HTTP Login service adapter of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 22.03.2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.adapter.http;

import java.security.SecureRandom;

import org.apache.commons.codec.binary.Base64;

/**
 * A generator for session IDs or page tokens.
 */
public class TokenGenerator {

    private final SecureRandom random;

    public TokenGenerator() {
        this.random = new SecureRandom();
    }
    
    public String generateToken() {
        
        byte[] bytes = new byte[24];
        this.random.nextBytes(bytes);
        
        return Base64.encodeBase64String(bytes).trim();
    }

}
