/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import java.util.function.Consumer;
import org.clazzes.login.adapter.http.GarbageCollector;
import org.clazzes.login.adapter.http.LoginInfoCache;
import org.clazzes.login.adapter.http.LoginServiceListener;
import org.clazzes.login.adapter.http.PageTokenServiceImpl;
import org.clazzes.login.adapter.http.TokenGenerator;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentSupport;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.CoreService;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.clazzes.util.http.sec.PageTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLoginComponent
extends ComponentSupport
implements Component {
    private static final Logger log = LoggerFactory.getLogger(HttpLoginComponent.class);
    public static final String CONFIG_PID = "org.clazzes.login.adapter.http";
    private GarbageCollector garbageCollector;
    private LoginServiceListener loginServiceListener;

    public synchronized void start(ServiceContext context) throws Exception {
        CoreService coreService = (CoreService)context.getService(CoreService.class).get();
        ServiceRegistry serviceRegistry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        ConfigurationEngine configurationEngine = (ConfigurationEngine)context.getService(ConfigurationEngine.class).get();
        TokenGenerator tg = new TokenGenerator();
        PageTokenServiceImpl ptsi = new PageTokenServiceImpl();
        ptsi.setTokenGenerator(tg);
        this.addService(serviceRegistry, "http-login", PageTokenService.class, ptsi);
        this.addListener(configurationEngine.listen(CONFIG_PID, (Consumer)ptsi));
        LoginInfoCache lic = new LoginInfoCache();
        lic.setTokenGenerator(tg);
        this.loginServiceListener = new LoginServiceListener(serviceRegistry);
        this.loginServiceListener.setLoginInfoCache(lic);
        this.loginServiceListener.setPageTokenService(ptsi);
        this.addListener(configurationEngine.listen(CONFIG_PID, (Consumer)this.loginServiceListener));
        this.garbageCollector = new GarbageCollector();
        this.garbageCollector.setPageTokenService(ptsi);
        this.garbageCollector.setLoginInfoCache(lic);
        this.garbageCollector.executorServiceBound(coreService.getScheduledExecutorService());
    }

    public synchronized void stop(ServiceContext context) throws Exception {
        CoreService coreService = (CoreService)context.getService(CoreService.class).get();
        ServiceRegistry serviceRegistry = (ServiceRegistry)context.getService(ServiceRegistry.class).get();
        this.removeAllServices(serviceRegistry);
        this.closeAllListeners((c, e) -> log.warn("Error closing [{}]", c, e));
        if (this.garbageCollector != null) {
            this.garbageCollector.executorServiceUnbound(coreService.getScheduledExecutorService());
            this.garbageCollector = null;
        }
        if (this.loginServiceListener != null) {
            this.loginServiceListener.stop();
            this.loginServiceListener = null;
        }
    }
}

