/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.clazzes.login.adapter.http.DomainHttpLoginService;
import org.clazzes.login.adapter.http.MFAState;
import org.clazzes.login.adapter.http.i18n.HttpLoginMessages;
import org.clazzes.util.aop.i18n.Messages;
import org.clazzes.util.http.LocaleHelper;
import org.clazzes.util.http.RequestHelper;
import org.clazzes.util.http.UrlHelper;
import org.clazzes.util.http.sec.PageTokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainLoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 6376913713678650071L;
    private static final Logger log = LoggerFactory.getLogger(DomainLoginServlet.class);
    private static final String XHTML_NS_URI = "http://www.w3.org/1999/xhtml";
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
    private static final int SC_EXPECT_TOKEN_OTP = 491;
    private static final int SC_EXPECT_EPHEMERAL_OTP = 492;
    private DomainHttpLoginService loginService;
    private PageTokenService pageTokenService;
    private String i18nPrefix;

    private final String getStringWithPfx(Messages i18n, String key) {
        String altKey;
        if (this.i18nPrefix != null && i18n.containsKey(altKey = this.i18nPrefix + "." + key)) {
            return i18n.getString(altKey);
        }
        return i18n.getString(key);
    }

    protected void writeLoginForm(Locale locale, String uri, HttpServletResponse resp, String css, boolean doTimeZoneDetection, String user, String pageToken, int status, String detailMessage, boolean allowSms, boolean fromOAuth) throws IOException, ServletException {
        Messages i18n = HttpLoginMessages.getMessages(locale);
        try {
            String lang = LocaleHelper.toXsLanguage((Locale)i18n.getLocale());
            resp.setHeader("X-Frame-Options", "SAMEORIGIN");
            resp.setHeader("Content-Language", lang);
            resp.setHeader("Cache-Control", "no-cache");
            resp.setHeader("Pragma", "no-cache");
            resp.setHeader("Expires", "0");
            resp.setContentType("text/html; charset=utf-8");
            resp.getOutputStream().write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n".getBytes("UTF-8"));
            XMLStreamWriter xsw = xmlOutputFactory.createXMLStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8");
            xsw.setDefaultNamespace(XHTML_NS_URI);
            boolean allowLogout = status == 491 || status == 492;
            xsw.writeStartElement("html");
            xsw.writeDefaultNamespace(XHTML_NS_URI);
            xsw.writeAttribute("lang", lang);
            xsw.writeAttribute("xml:lang", lang);
            xsw.writeStartElement("head");
            xsw.writeEmptyElement("meta");
            xsw.writeAttribute("http-equiv", "Content-Type");
            xsw.writeAttribute("content", "text/html; charset=utf-8");
            xsw.writeEmptyElement("link");
            xsw.writeAttribute("type", "text/css");
            xsw.writeAttribute("rel", "stylesheet");
            xsw.writeAttribute("href", css == null ? "../http-login.css" : css);
            if (doTimeZoneDetection && status != 200) {
                xsw.writeStartElement("script");
                xsw.writeAttribute("type", "text/javascript");
                xsw.writeAttribute("charset", "utf-8");
                xsw.writeAttribute("src", "../jstz.js");
                xsw.writeEndElement();
                xsw.writeStartElement("script");
                xsw.writeCharacters("\nfunction doTimeZoneDetection() {\n");
                xsw.writeCharacters("  if (location.search.match(/tz=(GMT[+\\-][0-9][0-9]:[0-9][0-9]|[\\w\\/]+)/)) {\n");
                xsw.writeCharacters("     document.forms.httpLoginForm.timeZone.value=RegExp.$1;\n");
                xsw.writeCharacters("  } else {\n");
                xsw.writeCharacters("    var tz = jstz.determine();\n");
                xsw.writeCharacters("    document.forms.httpLoginForm.timeZone.value=tz.name();\n");
                xsw.writeCharacters("  }\n");
                xsw.writeCharacters("}\n");
                xsw.writeEndElement();
            }
            xsw.writeStartElement("title");
            xsw.writeCharacters("HTTP Single-Sign-On");
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeStartElement("body");
            if (doTimeZoneDetection && status != 200) {
                xsw.writeAttribute("onload", "doTimeZoneDetection()");
            }
            xsw.writeStartElement("form");
            xsw.writeAttribute("id", "loginResultForm");
            xsw.writeEmptyElement("input");
            xsw.writeAttribute("type", "hidden");
            xsw.writeAttribute("name", "status");
            xsw.writeAttribute("value", String.valueOf(status));
            xsw.writeEmptyElement("input");
            xsw.writeAttribute("type", "hidden");
            xsw.writeAttribute("name", "principal");
            xsw.writeAttribute("value", user);
            xsw.writeEmptyElement("input");
            xsw.writeAttribute("type", "hidden");
            xsw.writeAttribute("name", "pageToken");
            xsw.writeAttribute("value", pageToken);
            xsw.writeEndElement();
            xsw.writeStartElement("form");
            xsw.writeAttribute("name", "httpLoginForm");
            xsw.writeAttribute("action", uri);
            xsw.writeAttribute("method", "post");
            xsw.writeEmptyElement("input");
            xsw.writeAttribute("type", "hidden");
            xsw.writeAttribute("name", "pageToken");
            xsw.writeAttribute("value", pageToken);
            if (allowLogout || status == 200) {
                xsw.writeEmptyElement("input");
                xsw.writeAttribute("type", "hidden");
                xsw.writeAttribute("name", "logout");
                xsw.writeAttribute("value", status == 200 ? "true" : "false");
            }
            if (doTimeZoneDetection && status != 200) {
                xsw.writeEmptyElement("input");
                xsw.writeAttribute("type", "hidden");
                xsw.writeAttribute("name", "timeZone");
                xsw.writeAttribute("value", "");
            }
            if (allowSms) {
                xsw.writeEmptyElement("input");
                xsw.writeAttribute("type", "hidden");
                xsw.writeAttribute("name", "generateSmsOtp");
                xsw.writeAttribute("value", "false");
            }
            if (fromOAuth) {
                xsw.writeEmptyElement("input");
                xsw.writeAttribute("type", "hidden");
                xsw.writeAttribute("name", "oauth");
                xsw.writeAttribute("value", "true");
            }
            xsw.writeStartElement("table");
            xsw.writeAttribute("class", "http-LoginForm");
            xsw.writeStartElement("tr");
            xsw.writeStartElement("td");
            xsw.writeAttribute("colspan", "2");
            xsw.writeAttribute("id", "messageTd");
            if (status == 403) {
                if (detailMessage == null) {
                    xsw.writeCharacters(this.getStringWithPfx(i18n, "user-or-password-invalid"));
                } else {
                    xsw.writeCharacters(this.getStringWithPfx(i18n, detailMessage));
                }
            } else if (status == 406) {
                xsw.writeCharacters(this.getStringWithPfx(i18n, "too-many-retries"));
            } else if (status == 200) {
                xsw.writeCharacters(this.getStringWithPfx(i18n, "login-ok"));
            } else if (status == 491) {
                xsw.writeCharacters(this.getStringWithPfx(i18n, "enter-token-otp"));
            } else if (status == 492) {
                xsw.writeCharacters(this.getStringWithPfx(i18n, "enter-ephemeral-otp"));
            } else {
                xsw.writeCharacters(this.getStringWithPfx(i18n, "enter-user-and-password"));
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
            if (status != 200) {
                if (status == 491) {
                    xsw.writeStartElement("tr");
                    xsw.writeStartElement("td");
                    xsw.writeStartElement("label");
                    xsw.writeAttribute("for", "tokenOtp");
                    xsw.writeCharacters(this.getStringWithPfx(i18n, "token-otp"));
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeEmptyElement("input");
                    xsw.writeAttribute("class", "http-login-TokenOtpTextBox");
                    xsw.writeAttribute("title", this.getStringWithPfx(i18n, "enter-token-otp"));
                    xsw.writeAttribute("type", "text");
                    xsw.writeAttribute("name", "tokenOtp");
                    xsw.writeAttribute("id", "tokenOtp");
                    xsw.writeAttribute("autocomplete", "off");
                    xsw.writeAttribute("autofocus", "autofocus");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                } else if (status == 492) {
                    xsw.writeStartElement("tr");
                    xsw.writeStartElement("td");
                    xsw.writeStartElement("label");
                    xsw.writeAttribute("for", "ephemeralOtp");
                    xsw.writeCharacters(this.getStringWithPfx(i18n, "ephemeral-otp"));
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeEmptyElement("input");
                    xsw.writeAttribute("class", "http-login-TextBox");
                    xsw.writeAttribute("title", this.getStringWithPfx(i18n, "enter-ephemeral-otp"));
                    xsw.writeAttribute("type", "text");
                    xsw.writeAttribute("name", "ephemeralOtp");
                    xsw.writeAttribute("id", "ephemeralOtp");
                    xsw.writeAttribute("autocomplete", "off");
                    xsw.writeAttribute("autofocus", "autofocus");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                } else {
                    xsw.writeStartElement("tr");
                    xsw.writeStartElement("td");
                    xsw.writeStartElement("label");
                    xsw.writeAttribute("for", "user");
                    xsw.writeCharacters(this.getStringWithPfx(i18n, "user"));
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeEmptyElement("input");
                    xsw.writeAttribute("class", "http-login-TextBox");
                    xsw.writeAttribute("title", String.format(locale, this.getStringWithPfx(i18n, "domainUserTitle"), this.loginService.getDefaultDomain()));
                    xsw.writeAttribute("placeholder", this.getStringWithPfx(i18n, "domainUserPlaceholder"));
                    xsw.writeAttribute("type", "text");
                    xsw.writeAttribute("name", "user");
                    xsw.writeAttribute("id", "user");
                    xsw.writeAttribute("autofocus", "autofocus");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeStartElement("tr");
                    xsw.writeStartElement("td");
                    xsw.writeStartElement("label");
                    xsw.writeAttribute("for", "password");
                    xsw.writeCharacters(this.getStringWithPfx(i18n, "password"));
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeStartElement("td");
                    xsw.writeEmptyElement("input");
                    xsw.writeAttribute("class", "http-login-PasswordTextBox");
                    xsw.writeAttribute("placeholder", this.getStringWithPfx(i18n, "password"));
                    xsw.writeAttribute("type", "password");
                    xsw.writeAttribute("name", "password");
                    xsw.writeAttribute("id", "password");
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                }
                if (fromOAuth) {
                    String href = "/oauth-login/login";
                    href = UrlHelper.appendQueryParameterToUrl((String)href, (String)"locale", (String)lang);
                    xsw.writeStartElement("tr");
                    xsw.writeStartElement("td");
                    xsw.writeAttribute("colspan", "2");
                    xsw.writeStartElement("a");
                    xsw.writeAttribute("href", href);
                    xsw.writeCharacters(i18n.getString("backToOAuth"));
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                }
            }
            xsw.writeStartElement("tr");
            xsw.writeStartElement("td");
            xsw.writeAttribute("colspan", "2");
            xsw.writeStartElement("fieldset");
            xsw.writeAttribute("id", "httpLoginFields");
            xsw.writeEmptyElement("input");
            xsw.writeAttribute("class", "http-login-Button");
            xsw.writeAttribute("type", "submit");
            String submitMsg = status == 200 ? this.getStringWithPfx(i18n, "loggingOut") : this.getStringWithPfx(i18n, "checkingCredentials");
            xsw.writeAttribute("onClick", "document.getElementById(\"httpLoginFields\").disabled = true; document.getElementById(\"messageTd\").innerHTML=\"" + submitMsg + "\"; document.forms.httpLoginForm.submit(); return false;");
            xsw.writeAttribute("value", status == 200 ? this.getStringWithPfx(i18n, "do-logout") : this.getStringWithPfx(i18n, "do-login"));
            if (allowSms) {
                xsw.writeCharacters("\u00a0");
                xsw.writeEmptyElement("input");
                xsw.writeAttribute("class", "http-login-Button");
                xsw.writeAttribute("type", "button");
                String sendMsg = this.getStringWithPfx(i18n, "generatingEphemeralOtp");
                xsw.writeAttribute("onClick", "document.getElementById(\"httpLoginFields\").disabled = true;  document.forms.httpLoginForm.generateSmsOtp.value='true'; document.getElementById(\"messageTd\").innerHTML=\"" + sendMsg + "\"; document.forms.httpLoginForm.submit(); return false;");
                xsw.writeAttribute("value", this.getStringWithPfx(i18n, "do-generate-otp"));
            }
            if (allowLogout) {
                xsw.writeCharacters("\u00a0");
                xsw.writeStartElement("input");
                xsw.writeAttribute("class", "http-login-Button");
                xsw.writeAttribute("type", "button");
                xsw.writeAttribute("onClick", "document.getElementById(\"httpLoginFields\").disabled = true;  document.forms.httpLoginForm.logout.value='true'; document.getElementById(\"messageTd\").innerHTML=\"" + this.getStringWithPfx(i18n, "loggingOut") + "\"; document.forms.httpLoginForm.submit(); return false;");
                xsw.writeAttribute("value", this.getStringWithPfx(i18n, "do-logout"));
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndElement();
            xsw.writeEndDocument();
            xsw.close();
            resp.flushBuffer();
        }
        catch (XMLStreamException e) {
            throw new ServletException("Error setting XML stream writer", (Throwable)e);
        }
    }

    protected static Locale getRequestLocale(HttpServletRequest req) {
        Locale locale = req.getLocale();
        String locale_s = req.getParameter("locale");
        if (locale_s != null) {
            locale = LocaleHelper.localeFromXsLanguage((String)locale_s);
        }
        return locale;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        MFAState login = this.loginService.checkMFALogin(req);
        boolean fromOAuth = "true".equals(req.getParameter("oauth"));
        this.writeResponse(req, resp, login, false, DomainLoginServlet.getRequestLocale(req), null, fromOAuth);
    }

    protected void writeResponse(HttpServletRequest req, HttpServletResponse resp, MFAState login, boolean wasPost, Locale locale, String detailMessage, boolean fromOAuth) throws ServletException, IOException {
        String user;
        int status;
        String css = req.getParameter("css");
        String pageToken = null;
        boolean allowSms = false;
        if (login == null) {
            status = !this.loginService.checkPermission(req, this.loginService.getLoginUrl()) ? 406 : (wasPost ? 403 : 401);
            user = "";
        } else {
            user = login.getPrincipal().getName();
            if (login.getState() == MFAState.State.AUTHENTICATED) {
                status = 200;
            } else if (login.getState() == MFAState.State.TOKEN_PENDING) {
                status = 491;
                allowSms = this.loginService.mayReveiceEphemeralOtp(login);
            } else {
                status = login.getState() == MFAState.State.EPHEMERAL_PENDING ? 492 : 403;
            }
            if (wasPost) {
                pageToken = req.getParameter("pageToken");
            }
        }
        if (pageToken == null) {
            pageToken = this.pageTokenService.getPageToken(req);
        }
        String uri = req.getRequestURI();
        String locale_s = req.getParameter("locale");
        if (locale_s != null) {
            uri = UrlHelper.appendQueryParameterToUrl((String)uri, (String)"locale", (String)locale_s);
        }
        if (css != null) {
            uri = UrlHelper.appendQueryParameterToUrl((String)uri, (String)"css", (String)css);
        }
        this.writeLoginForm(locale, uri, resp, css, this.loginService.isDoTimeZoneDetection(), user, pageToken, status, detailMessage, allowSms, fromOAuth);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        MFAState login = null;
        String detailMessage = null;
        String logout = req.getParameter("logout");
        boolean isLogout = "true".equals(logout);
        boolean fromOAuth = "true".equals(req.getParameter("oauth"));
        Locale locale = DomainLoginServlet.getRequestLocale(req);
        if (isLogout) {
            fromOAuth |= this.loginService.logoutCheckForOAuth(req);
        } else {
            try {
                String pageToken = req.getParameter("pageToken");
                if (this.pageTokenService.checkPageToken(req, pageToken)) {
                    String sendSms = req.getParameter("generateSmsOtp");
                    String tokenOtp = req.getParameter("tokenOtp");
                    String ephemeralOtp = req.getParameter("ephemeralOtp");
                    if ("true".equals(sendSms)) {
                        login = this.loginService.generateSmsToken(req, locale);
                    } else if (tokenOtp != null) {
                        login = this.loginService.checkTokenOtp(req, resp, tokenOtp, locale);
                    } else if (ephemeralOtp != null) {
                        login = this.loginService.checkEphemeralOtp(req, resp, ephemeralOtp, locale);
                    } else {
                        String domain;
                        String user = req.getParameter("user");
                        String password = req.getParameter("password");
                        int slashIdx = Math.max(user.indexOf(47), user.indexOf(92));
                        if (slashIdx < 0) {
                            int atIdx = user.indexOf(64);
                            if (atIdx < 0) {
                                domain = this.loginService.getDefaultDomain();
                            } else {
                                domain = user.substring(atIdx + 1);
                                user = user.substring(0, atIdx);
                            }
                        } else {
                            domain = user.substring(0, slashIdx);
                            user = user.substring(slashIdx + 1);
                        }
                        String tz_s = req.getParameter("timeZone");
                        TimeZone tz = tz_s == null || tz_s.isEmpty() ? null : TimeZone.getTimeZone(tz_s);
                        login = this.loginService.tryLogin(req, resp, domain, user, password, locale, tz);
                    }
                }
            }
            catch (RuntimeException e) {
                log.error("Caught exception during login", (Throwable)e);
                this.loginService.logout(req);
                login = null;
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (cause instanceof CertificateExpiredException) {
                        detailMessage = "valid-certificate-expired";
                    } else if (cause instanceof CertificateNotYetValidException) {
                        detailMessage = "no-valid-certificate";
                    }
                }
            }
            catch (Throwable e) {
                log.error("Caught exception during login", e);
                this.loginService.logout(req);
                login = null;
            }
            if (login == null) {
                log.error("Bad login from [{}].", (Object)RequestHelper.getRealRemoteIP((HttpServletRequest)req));
                long failureTimeout = this.loginService.getFailureTimeout();
                if (failureTimeout > 0L) {
                    try {
                        Thread.sleep(failureTimeout);
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("Wait after HTTP login failure has been interupted.");
                    }
                }
            }
        }
        this.writeResponse(req, resp, login, !isLogout, locale, detailMessage, fromOAuth);
    }

    public void setLoginService(DomainHttpLoginService loginService) {
        this.loginService = loginService;
    }

    public void setPageTokenService(PageTokenService pageTokenService) {
        this.pageTokenService = pageTokenService;
    }

    public void setI18nPrefix(String i18nPrefix) {
        this.i18nPrefix = i18nPrefix;
    }

    public String getServletInfo() {
        return DomainLoginServlet.class.getSimpleName();
    }

    static {
        xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

