/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import java.security.Principal;
import java.util.List;
import org.clazzes.util.sec.DomainPrincipal;
import org.clazzes.util.sec.MFAPrincipal;

public class MFAState {
    private final DomainPrincipal principal;
    private final List<? extends Principal> groups;
    private final MFAPrincipal mfaPrincipal;
    private final State state;
    private final String ephemeralOtp;
    private final long ephemeralOtpExpiry;

    public MFAState(DomainPrincipal principal, List<? extends Principal> groups) {
        this.principal = principal;
        this.groups = groups;
        if (principal instanceof MFAPrincipal) {
            this.mfaPrincipal = (MFAPrincipal)principal;
            this.state = this.mfaPrincipal.getKnownTokenIds() == null ? State.EPHEMERAL_NEEDED : State.TOKEN_PENDING;
        } else {
            this.mfaPrincipal = null;
            this.state = State.AUTHENTICATED;
        }
        this.ephemeralOtp = null;
        this.ephemeralOtpExpiry = 0L;
    }

    public MFAState(DomainPrincipal principal, List<? extends Principal> groups, String ephemeralOtp, long ephemeralOtpExpiry) {
        this.principal = principal;
        this.groups = groups;
        if (principal instanceof MFAPrincipal) {
            this.mfaPrincipal = (MFAPrincipal)principal;
            this.state = ephemeralOtp == null ? State.EPHEMERAL_NEEDED : State.EPHEMERAL_PENDING;
        } else {
            this.mfaPrincipal = null;
            this.state = State.AUTHENTICATED;
        }
        this.ephemeralOtp = ephemeralOtp;
        this.ephemeralOtpExpiry = ephemeralOtpExpiry;
    }

    public MFAState(MFAState old) {
        this.principal = old.getPrincipal();
        this.groups = old.getGroups();
        this.mfaPrincipal = old.getMfaPrincipal();
        this.state = State.AUTHENTICATED;
        this.ephemeralOtp = null;
        this.ephemeralOtpExpiry = 0L;
    }

    public DomainPrincipal getPrincipal() {
        return this.principal;
    }

    public List<? extends Principal> getGroups() {
        return this.groups;
    }

    public MFAPrincipal getMfaPrincipal() {
        return this.mfaPrincipal;
    }

    public State getState() {
        return this.state;
    }

    public long getEphemeralOtpExpiry() {
        return this.ephemeralOtpExpiry;
    }

    public String getEphemeralOtp() {
        return this.ephemeralOtp;
    }

    static enum State {
        AUTHENTICATED,
        TOKEN_PENDING,
        EPHEMERAL_NEEDED,
        EPHEMERAL_PENDING;

    }
}

