/***********************************************************
 * $Id$
 *
 * HTTP Login service adapter of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 19.09.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/
package org.clazzes.login.adapter.http.i18n;

import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 * I18N texts.
 */
public class Messages extends ListResourceBundle {

    public static final ResourceBundle getLocalizedVersion(Locale locale) {
        return Messages.getBundle(Messages.class.getName(),locale,
                ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_CLASS));
    }

    @Override
    protected Object[][] getContents() {

        return new Object[][] {
            { "user", "User" },
            { "password", "Password" },
            { "token-otp", "YubiKey OTP" },
            { "ephemeral-otp", "SMS OTP" },
            { "domainUserTitle", "Please enter a user in the domain \"%s\" or a user in another domain using the format \"user@domain\" or \"domain/user\"." },
            { "domainUserPlaceholder", "user@domain" },
            { "enter-user-and-password", "Please enter domain, user and password." },
            { "enter-token-otp", "Please enter the YubiKey OTP by pressing the button on your token." },
            { "enter-ephemeral-otp", "Please enter the OTP sent via SMS." },
            { "user-or-password-invalid", "The provided user or password is invalid." },
            { "valid-certificate-expired", "The certificate has expired."},
            { "no-valid-certificate", "The user has no valid certificate." },
            { "too-many-retries", "Authentication blocked after too many unsuccessful attempts." },
            { "login-ok", "Login successful." },
            { "do-login", "Login"},
            { "do-logout", "Logout"},
            { "do-generate-otp", "Generate SMS OTP" },
            { "checkingCredentials", "Checking login credentials..."},
            { "generatingEphemeralOtp", "Sending an SMS OTP..."},
            { "loggingOut", "Logging out..."},
            { "domainless.domainUserTitle", "Please enter the user." },
            { "domainless.domainUserPlaceholder", "User" },
            { "domainless.enter-user-and-password", "Please enter user and password." },
            { "challengeDomainless.domainUserTitle", "Please enter the registration code." },
            { "challengeDomainless.enter-user-and-password", "Please enter both registration code and security code." },
            { "challengeDomainless.user", "Registration code" },
            { "challengeDomainless.password", "Security code" },
            { "challengeDomainless.domainUserPlaceholder", "Registration code" },
            { "emphemeralOtpSms.subject", "OTP for user %s on host %s" },
            { "emphemeralOtpSms.body", "OTP for user %s on host %s:\n%s" },
            { "backToOAuth", "Back to OAuth Login\u2026"}
        };
    }

}
