package org.clazzes.login.adapter.http;

import java.util.Locale;

import org.clazzes.util.sec.DomainPrincipal;
import org.clazzes.util.sec.MFAPrincipal;
import org.clazzes.util.sec.TokenOtpChecker;

public interface MFAService {

    /**
     * Check a token OTP using {@link TokenOtpChecker#checkOTP(String, String[])}
     * 
     * @param otp The one-time-pad.
     * @param knownIds A list of known token IDs for the user.
     * @return
     */
    boolean checkTokenOtp(String otp, String[] knownIds);

    /**
     * Generate an ephemeral OTP and deliver it to the pre-authenticated user.
     * 
     * @param locale The locale used for generating a localized SMS message.
     * @param host The host to authenticate against.
     * @param principal The pre-authenticated principal.
     * @param mfaPrincipal The MFA aspect of the pre-authenticated principal.
     * @return A new 8-character ephemeral OTP.
     */
    String generateEmphemeralOtp(Locale locale, String host,
            DomainPrincipal principal, MFAPrincipal mfaPrincipal);
    
    /**
     * @param principal The pre-authenticated principal.
     * @param mfaPrincipal The MFA aspect of the pre-authenticated principal.
     * @return Whether the given user my receive an OTP weither via SMS or email.
     */
    public boolean mayReceiveEphemeralOtp(DomainPrincipal principal, MFAPrincipal mfaPrincipal);

}