/***********************************************************
 * $Id$
 *
 * HTTP Login service adapter of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 19.09.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.login.adapter.http;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/**
 * A cache entry for login credentials.
 */
public class LoginInfo {

	private final String sessionId;
	private final boolean fromOAuth;
	private Map<String,MFAState> mfaStatesByMechanism;
	private Locale locale;
	private TimeZone timeZone;
	private long expires;

	public LoginInfo(String sessionId, Locale locale, TimeZone timeZone, boolean fromOAuth) {
		this.sessionId = sessionId;
		this.locale = locale;
		this.timeZone = timeZone;
		this.fromOAuth = fromOAuth;
	}
	public String getSessionId() {
		return this.sessionId;
	}

	public boolean isFromOAuth() {
		return this.fromOAuth;
	}

	public synchronized MFAState getMFAState(String mechanism) {

		if (this.mfaStatesByMechanism == null) {
			return null;
		}
		else {
			return this.mfaStatesByMechanism.get(mechanism);
		}
	}
	public synchronized MFAState removeMFAState(String mechanism) {
		if (this.mfaStatesByMechanism == null) {
			return null;
		}
		else {
			return this.mfaStatesByMechanism.remove(mechanism);
		}
	}
	public synchronized void addMFAState(String mechanism, MFAState state) {

		if (this.mfaStatesByMechanism == null) {
			this.mfaStatesByMechanism = new HashMap<String,MFAState>();
		}
		this.mfaStatesByMechanism.put(mechanism,state);
	}

	public synchronized Locale getLocale() {
		return this.locale;
	}
	public synchronized TimeZone getTimeZone() {
		return this.timeZone;
	}
	public synchronized void setLocale(Locale locale) {
		this.locale = locale;
	}
	public synchronized void setTimeZone(TimeZone timeZone) {
		this.timeZone = timeZone;
	}
	public synchronized long getExpires() {
		return this.expires;
	}
	public synchronized void touch(long maxAge) {
		this.expires = System.currentTimeMillis() + maxAge;
	}
	public synchronized String getPrincipalsInfo() {

		if (this.mfaStatesByMechanism == null) {
			return "<no principals>";
		}

		StringBuffer sb = new StringBuffer();

		for (Map.Entry<String,MFAState> e:this.mfaStatesByMechanism.entrySet()) {

			MFAState p = e.getValue();

			if (sb.length() > 0) {
				sb.append(",");
			}

			sb.append(p.getPrincipal().getClass().getName());
			sb.append("::");
			sb.append(p.getPrincipal().getName());
		}

		return sb.toString();
	}

}
