/***********************************************************
 * $Id$
 * 
 * HTTP Login service adapter of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 19.09.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.login.adapter.http;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The garbage collector bean.
 */
public class GarbageCollector {

    private static final Logger log = LoggerFactory.getLogger(GarbageCollector.class);
    
    private LoginInfoCache loginInfoCache;
    private PageTokenServiceImpl pageTokenService;
    
    private ScheduledExecutorService executorService;
    
    private Future<?> future;
	
    private void cancelFuture() {

        if (this.future != null) {
            log.info("Stopping http-login-adapter garbage collection.");
            this.future.cancel(true);
            this.future = null;
        }
    }
    
    public void executorServiceBound(ScheduledExecutorService executorService) {
	
        this.cancelFuture();
        
        this.executorService = executorService;
        
        if (this.executorService != null) {
            
            long interval = 60;
            
            log.info("Starting http-login-adapter garbage collection to be scheduled each [{}] seconds.",interval);
            
            this.future = this.executorService.scheduleAtFixedRate(new Runnable() {
                
                @Override
                public void run() {
                    
                    GarbageCollector.this.loginInfoCache.gc();
                    GarbageCollector.this.pageTokenService.gc();
                }
            },interval,interval,TimeUnit.SECONDS);
        }
    }
    
    public void executorServiceUnbound(ScheduledExecutorService executorService) {

        this.cancelFuture();
        this.executorService = null;
    }
    
    public void setLoginInfoCache(LoginInfoCache loginInfoCache) {
        this.loginInfoCache = loginInfoCache;
    }
    
    public void setPageTokenService(PageTokenServiceImpl pageTokenService) {
        this.pageTokenService = pageTokenService;
    }
}
