/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.clazzes.login.adapter.http.LoginInfo;
import org.clazzes.login.adapter.http.MFAState;
import org.clazzes.login.adapter.http.TokenGenerator;
import org.clazzes.util.sec.DomainPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginInfoCache {
    private static final Logger log = LoggerFactory.getLogger(LoginInfoCache.class);
    private final Map<String, LoginInfo> infosBySessionId = new HashMap<String, LoginInfo>(1024);
    private TokenGenerator tokenGenerator;

    public synchronized LoginInfo getLoginInfo(String sessionId) {
        LoginInfo ret = this.infosBySessionId.get(sessionId);
        return ret;
    }

    public synchronized LoginInfo removeLoginInfo(String sessionId) {
        return this.infosBySessionId.remove(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginInfo createLoginInfo(String sessionId, String mechanism, MFAState mfaState, Locale locale, TimeZone timeZone, long maxAge, boolean fromOAuth) {
        LoginInfo ret = null;
        if (sessionId != null) {
            LoginInfoCache loginInfoCache = this;
            synchronized (loginInfoCache) {
                ret = this.infosBySessionId.get(sessionId);
            }
        }
        if (ret != null) {
            if (locale != null && !locale.equals(ret.getLocale())) {
                if (log.isWarnEnabled()) {
                    log.warn("Overriding locale [{}] of login [{}] with new value [{}] from mechanism [{}].", new Object[]{ret.getLocale(), ret.getPrincipalsInfo(), locale, mechanism});
                }
                ret.setLocale(locale);
            }
            if (timeZone != null && !timeZone.equals(ret.getTimeZone())) {
                if (log.isWarnEnabled()) {
                    log.warn("Overriding time zone [{}] of login [{}] with new value [{}] from mechanism [{}].", new Object[]{ret.getTimeZone(), ret.getPrincipalsInfo(), timeZone, mechanism});
                }
                ret.setTimeZone(timeZone);
            }
            ret.addMFAState(mechanism, mfaState);
            ret.touch(maxAge);
            return ret;
        }
        int ntry = 0;
        DomainPrincipal principal = mfaState.getPrincipal();
        do {
            ++ntry;
            String key = this.tokenGenerator.generateToken();
            ret = new LoginInfo(key, locale, timeZone, fromOAuth);
            LoginInfoCache loginInfoCache = this;
            synchronized (loginInfoCache) {
                if (this.infosBySessionId.containsKey(key)) {
                    log.warn("Duplicate session ID generated by SecureRandom for principal [{}] of type [{}].", (Object)principal.getName(), (Object)principal.getClass().getName());
                    ret = null;
                } else {
                    this.infosBySessionId.put(key, ret);
                    ret.addMFAState(mechanism, mfaState);
                }
            }
        } while (ret == null && ntry < 5);
        if (ret == null) {
            throw new SecurityException("[" + ntry + "] duplicate session IDs generated by SecureRandom for principal [" + principal.getName() + "] of type [" + principal.getClass().getName() + "].");
        }
        ret.touch(maxAge);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        long now = System.currentTimeMillis();
        LoginInfoCache loginInfoCache = this;
        synchronized (loginInfoCache) {
            if (log.isDebugEnabled()) {
                log.debug("Starting login info garbage collection, number of persisted session IDs is [{}]...", (Object)this.infosBySessionId.size());
            }
            Iterator<Map.Entry<String, LoginInfo>> it = this.infosBySessionId.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, LoginInfo> e = it.next();
                if (e.getValue().getExpires() > now) continue;
                if (log.isWarnEnabled()) {
                    log.warn("Login [{}] expired without prior logout.", (Object)e.getValue().getPrincipalsInfo());
                }
                it.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug("Login info garbage collection finished, number of persisted session IDs is [{}].", (Object)this.infosBySessionId.size());
            }
        }
    }

    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }
}

