/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.clazzes.login.adapter.http.MFAState;

public class LoginInfo {
    private final String sessionId;
    private final boolean fromOAuth;
    private Map<String, MFAState> mfaStatesByMechanism;
    private Locale locale;
    private TimeZone timeZone;
    private long expires;

    public LoginInfo(String sessionId, Locale locale, TimeZone timeZone, boolean fromOAuth) {
        this.sessionId = sessionId;
        this.locale = locale;
        this.timeZone = timeZone;
        this.fromOAuth = fromOAuth;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isFromOAuth() {
        return this.fromOAuth;
    }

    public synchronized MFAState getMFAState(String mechanism) {
        if (this.mfaStatesByMechanism == null) {
            return null;
        }
        return this.mfaStatesByMechanism.get(mechanism);
    }

    public synchronized MFAState removeMFAState(String mechanism) {
        if (this.mfaStatesByMechanism == null) {
            return null;
        }
        return this.mfaStatesByMechanism.remove(mechanism);
    }

    public synchronized void addMFAState(String mechanism, MFAState state) {
        if (this.mfaStatesByMechanism == null) {
            this.mfaStatesByMechanism = new HashMap<String, MFAState>();
        }
        this.mfaStatesByMechanism.put(mechanism, state);
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized TimeZone getTimeZone() {
        return this.timeZone;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale = locale;
    }

    public synchronized void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public synchronized long getExpires() {
        return this.expires;
    }

    public synchronized void touch(long maxAge) {
        this.expires = System.currentTimeMillis() + maxAge;
    }

    public synchronized String getPrincipalsInfo() {
        if (this.mfaStatesByMechanism == null) {
            return "<no principals>";
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, MFAState> e : this.mfaStatesByMechanism.entrySet()) {
            MFAState p = e.getValue();
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p.getPrincipal().getClass().getName());
            sb.append("::");
            sb.append(p.getPrincipal().getName());
        }
        return sb.toString();
    }
}

