/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.login.adapter.http;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.clazzes.login.adapter.http.DomainHttpLoginService;
import org.clazzes.login.adapter.http.DomainLoginServlet;
import org.clazzes.login.adapter.http.LoginInfoCache;
import org.clazzes.login.adapter.http.MFAService;
import org.clazzes.login.adapter.http.SameSitePolicy;
import org.clazzes.util.http.osgi.DefaultHttpContext;
import org.clazzes.util.http.sec.HttpLoginService;
import org.clazzes.util.http.sec.PageTokenService;
import org.clazzes.util.osgi.ServiceMapListener2;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServiceListener
implements ServiceMapListener2,
ManagedService {
    private static final Logger log = LoggerFactory.getLogger(LoginServiceListener.class);
    private HttpService httpService;
    private Bundle bundle;
    private LoginInfoCache loginInfoCache;
    private PageTokenService pageTokenService;
    private MFAService mfaService;
    private int sessionTimeout = 180;
    private long failureTimeout;
    private String sessionCookie;
    private boolean secureCookie;
    private SameSitePolicy sameSitePolicy;
    private boolean doTimeZoneDetection;
    private boolean doGroupsCheck;
    private boolean logoutAllMechanisms = true;
    private int ephemeralOtpSeconds;
    private Map<String, ServiceInfo> registrations;

    private static final String makeServletAlias(String mechanism) {
        return "/http-login/" + mechanism;
    }

    private final void deregisterLoginServlet(ServiceInfo serviceInfo) {
        if (serviceInfo.getServletAlias() != null) {
            log.info("Deregistering login servlet [{}]", (Object)serviceInfo.getServletAlias());
            this.httpService.unregister(serviceInfo.getServletAlias());
            serviceInfo.setServletAlias(null);
        }
    }

    private final void registerLoginServlet(String mechanism, ServiceInfo serviceInfo) {
        DomainLoginServlet loginServlet = new DomainLoginServlet();
        loginServlet.setLoginService(serviceInfo.getDomainHttpLoginService());
        loginServlet.setPageTokenService(this.pageTokenService);
        loginServlet.setI18nPrefix(serviceInfo.getI18nPrefix());
        String alias = LoginServiceListener.makeServletAlias(mechanism);
        log.info("Registering login servlet [{}]", (Object)alias);
        try {
            this.httpService.registerServlet(alias, (Servlet)loginServlet, null, DefaultHttpContext.getInstance());
            serviceInfo.setServletAlias(alias);
        }
        catch (Exception e) {
            log.error("Error registering login servlet [" + alias + "]", (Throwable)e);
        }
    }

    public synchronized void httpServiceBound(HttpService httpService) {
        this.httpService = httpService;
        if (this.registrations != null) {
            for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                this.registerLoginServlet(entry.getKey(), entry.getValue());
            }
        }
    }

    public synchronized void httpServiceUnbound(HttpService httpService) {
        if (this.httpService == null) {
            log.warn("HttpService became unavailable without prior registration.");
            return;
        }
        if (this.registrations != null) {
            for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                this.deregisterLoginServlet(entry.getValue());
            }
        }
        this.httpService = null;
    }

    public synchronized void serviceBound(String mechanism, Object service, Map<String, Object> serviceProperties) {
        DomainPasswordLoginService domainPasswordLoginService = (DomainPasswordLoginService)service;
        DomainHttpLoginService loginService = new DomainHttpLoginService();
        loginService.setLoginInfoCache(this.loginInfoCache);
        loginService.setMfaService(this.mfaService);
        loginService.setLoginMechanism(mechanism);
        loginService.setDomainPasswordLoginService(domainPasswordLoginService);
        loginService.setFailureTimeout(this.failureTimeout);
        loginService.setSessionTimeout(this.sessionTimeout);
        loginService.setDoTimeZoneDetection(this.doTimeZoneDetection);
        loginService.setDoGroupsCheck(this.doGroupsCheck);
        loginService.setLogoutAllMechanisms(this.logoutAllMechanisms);
        loginService.setSecureCookie(this.secureCookie);
        loginService.setSameSitePolicy(this.sameSitePolicy);
        loginService.setSessionCookie(this.sessionCookie);
        loginService.setEphemeralOtpSeconds(this.ephemeralOtpSeconds);
        log.info("Registering HttpLoginService for mechanism [{}]", (Object)mechanism);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("login.mechanism", mechanism);
        ServiceRegistration httpLoginServiceRegistration = this.bundle.getBundleContext().registerService(HttpLoginService.class.getName(), (Object)loginService, properties);
        ServiceInfo info = new ServiceInfo((ServiceRegistration<HttpLoginService>)httpLoginServiceRegistration, loginService, serviceProperties);
        if (this.httpService != null) {
            this.registerLoginServlet(mechanism, info);
        }
        if (this.registrations == null) {
            this.registrations = new HashMap<String, ServiceInfo>();
        }
        this.registrations.put(mechanism, info);
    }

    public synchronized void serviceUnbound(String mechanism, Object service, Map<String, Object> serviceProperties) {
        ServiceInfo info = this.registrations.remove(mechanism);
        if (info == null) {
            log.warn("DomainPasswordLoginService for mechanism [{}] became unavailable wihtout prior registration.", (Object)mechanism);
            return;
        }
        log.info("Unregistering HttpLoginService for mechanism [{}]", (Object)mechanism);
        info.getHttpLoginServiceRegistration().unregister();
        if (this.httpService != null) {
            this.deregisterLoginServlet(info);
        }
        if (this.registrations.isEmpty()) {
            this.registrations = null;
        }
    }

    public synchronized void updated(Dictionary properties) throws ConfigurationException {
        Object ephemeralOtpSeconds_s;
        Object logoutAllMechanisms_s;
        Object sameSitePolicy_s;
        Object v;
        Object v2;
        Object v3;
        Object v4;
        Object failureTimeout_s;
        Object sessionTimeout_s;
        if (log.isDebugEnabled()) {
            log.debug("updated called: properties=[{}]", (Object)properties);
        }
        if ((sessionTimeout_s = properties.get("sessionTimeout")) != null) {
            this.sessionTimeout = Integer.parseInt(sessionTimeout_s.toString());
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting sessionTimeout [{}] on login service with mechanism [{}]", (Object)this.sessionTimeout, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setSessionTimeout(this.sessionTimeout);
                }
            }
        }
        if ((failureTimeout_s = properties.get("failureTimeout")) != null) {
            this.failureTimeout = Integer.parseInt(failureTimeout_s.toString());
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting failureTimeout [{}] on login service with mechanism [{}]", (Object)this.failureTimeout, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setFailureTimeout(this.failureTimeout);
                }
            }
        }
        if ((v4 = properties.get("doTimeZoneDetection")) != null) {
            this.doTimeZoneDetection = Boolean.parseBoolean(v4.toString());
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting doTimeZoneDetection [{}] on login service with mechanism [{}]", (Object)this.doTimeZoneDetection, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setDoTimeZoneDetection(this.doTimeZoneDetection);
                }
            }
        }
        if ((v3 = properties.get("doGroupsCheck")) != null) {
            this.doGroupsCheck = Boolean.parseBoolean(v3.toString());
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting doGroupsCheck [{}] on login service with mechanism [{}]", (Object)this.doGroupsCheck, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setDoGroupsCheck(this.doGroupsCheck);
                }
            }
        }
        if ((v2 = properties.get("sessionCookie")) != null) {
            this.sessionCookie = v2.toString();
            char c = this.sessionCookie.charAt(0);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                throw new ConfigurationException("sessionCookie", "session\u0106ookie does not start with an ASCII letter.");
            }
            for (int i = 1; i < this.sessionCookie.length(); ++i) {
                char c2 = this.sessionCookie.charAt(i);
                if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_') continue;
                throw new ConfigurationException("sessionCookie", "session\u0106ookie contains chracters other than ASCII numbers, letters or underscores.");
            }
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting sessionCookie [{}] on login service with mechanism [{}]", (Object)this.sessionCookie, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setSessionCookie(this.sessionCookie);
                }
            }
        }
        if ((v = properties.get("secureCookie")) != null) {
            this.secureCookie = Boolean.parseBoolean(v.toString());
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting secureCookie [{}] on login service with mechanism [{}]", (Object)this.secureCookie, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setSecureCookie(this.secureCookie);
                }
            }
        }
        if ((sameSitePolicy_s = properties.get("sameSitePolicy")) != null) {
            String v5 = sameSitePolicy_s.toString().trim();
            SameSitePolicy sameSitePolicy = this.sameSitePolicy = v5.isEmpty() ? null : SameSitePolicy.valueOf(v5);
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting sameSitePolicy [{}] on login service with mechanism [{}]", (Object)this.sameSitePolicy, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setSameSitePolicy(this.sameSitePolicy);
                }
            }
        }
        if ((logoutAllMechanisms_s = properties.get("logoutAllMechanisms")) != null) {
            this.logoutAllMechanisms = Boolean.parseBoolean(logoutAllMechanisms_s.toString());
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting logoutAllMechanisms [{}] on login service with mechanism [{}]", (Object)this.logoutAllMechanisms, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setLogoutAllMechanisms(this.logoutAllMechanisms);
                }
            }
        }
        if ((ephemeralOtpSeconds_s = properties.get("ephemeralOtpSeconds")) != null) {
            this.ephemeralOtpSeconds = Integer.parseInt(ephemeralOtpSeconds_s.toString());
            if (this.registrations != null) {
                for (Map.Entry<String, ServiceInfo> entry : this.registrations.entrySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Setting ephemeralOtpSeconds [{}] on login service with mechanism [{}]", (Object)this.logoutAllMechanisms, (Object)entry.getKey());
                    }
                    entry.getValue().getDomainHttpLoginService().setEphemeralOtpSeconds(this.ephemeralOtpSeconds);
                }
            }
        }
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public void setLoginInfoCache(LoginInfoCache loginInfoCache) {
        this.loginInfoCache = loginInfoCache;
    }

    public void setPageTokenService(PageTokenService pageTokenService) {
        this.pageTokenService = pageTokenService;
    }

    public void setMfaService(MFAService mfaService) {
        this.mfaService = mfaService;
    }

    private static final class ServiceInfo {
        private final ServiceRegistration<HttpLoginService> httpLoginServiceRegistration;
        private final DomainHttpLoginService domainHttpLoginService;
        private final String i18nPrefix;
        private String servletAlias;

        public ServiceInfo(ServiceRegistration<HttpLoginService> httpLoginServiceRegistration, DomainHttpLoginService domainHttpLoginService, Map<String, Object> serviceProperties) {
            this.httpLoginServiceRegistration = httpLoginServiceRegistration;
            this.domainHttpLoginService = domainHttpLoginService;
            Object i18nPfx = null;
            if (serviceProperties != null) {
                i18nPfx = serviceProperties.get("login.i18n.prefix");
            }
            this.i18nPrefix = i18nPfx == null ? null : i18nPfx.toString();
        }

        public ServiceRegistration<HttpLoginService> getHttpLoginServiceRegistration() {
            return this.httpLoginServiceRegistration;
        }

        public DomainHttpLoginService getDomainHttpLoginService() {
            return this.domainHttpLoginService;
        }

        public String getI18nPrefix() {
            return this.i18nPrefix;
        }

        public String getServletAlias() {
            return this.servletAlias;
        }

        public void setServletAlias(String servletAlias) {
            this.servletAlias = servletAlias;
        }
    }
}

