/***********************************************************
 * $Id$
 * 
 * HTTP Login service adapter of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 19.09.2012
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/
package org.clazzes.login.adapter.http.i18n;

import java.util.ListResourceBundle;

/**
 * French translations.
 */
public class Messages_fr extends ListResourceBundle {

    @Override
    protected Object[][] getContents() {

        return new Object[][] {
            { "user", "Utilisateur" },
            { "password", "Mot de passe" },
            { "token-otp", "OTP YubiKey" },
            { "ephemeral-otp", "OTP SMS" },
            { "domainUserTitle", "Veuillez entrer l’utilisatuer dans le domaine \"%s\" ou un utilisateur dans un autre domaine en format \"Utilisateur@Domaine\" ou \"Domaine/Utilisateur\"." },
            { "domainUserPlaceholder", "Utilisateur@Domaine" },
            { "enter-user-and-password", "Veuillez entrer le domaine, l’utilisateur et le mot de passe." },
            { "enter-token-otp", "Veuillez entrer l’OTP YubiKey par pousser le bouton à votre clé de sécurité." },
            { "enter-ephemeral-otp", "Veuillez entrer l’OTP, que vous avez reçu par SMS." },
            { "user-or-password-invalid", "L’utilisateur ou le mot de passe et invalide." },
            { "valid-certificate-expired", "Le certificat a expiré."},
            { "no-valid-certificate", "L’utilisatuer n’a pas un certificat valide." },				
            { "too-many-retries", "Vous avez entrepris trop des tentatives fausses de se connecter." },
            { "login-ok", "Connecté avec succès." },
            { "do-login", "Se connecter"},
            { "do-logout", "Se déconnecter" },
            { "do-generate-otp", "Envoyer OTP SMS" },
            { "checkingCredentials", "Vérifiant votres données d’identification..."},
            { "generatingEphemeralOtp", "Envoyant l’OTP SMS..."},
            { "loggingOut", "Vous déconnectant..."},
            { "emphemeralOtpSms.subject", "OTP pour l'utilisateur %s à l'hôte %s" },
            { "emphemeralOtpSms.body", "OTP pour l'utilisateur %s à l'hôte %s:\n%s" }
        };
    }

}
